<?php

///////////////////////////////////////
// sanitize.inc.php
// Sanitization functions for PHP
// by: Gavin Zuchlinski, Jamie Pratt, Hokkaido
// webpage: http://libox.net
// Last modified: September 27, 2003
//
// Many thanks to those on the webappsec list for helping me improve these functions
///////////////////////////////////////
// Function list:
// sanitize_paranoid_string($string) -- input string, returns string stripped of all non 
//           alphanumeric
// sanitize_system_string($string) -- input string, returns string stripped of special
//           characters
// sanitize_sql_string($string) -- input string, returns string with slashed out quotes
// sanitize_html_string($string) -- input string, returns string with html replacements
//           for special characters
// sanitize_int($integer) -- input integer, returns ONLY the integer (no extraneous 
//           characters
// sanitize_float($float) -- input float, returns ONLY the float (no extraneous 
//           characters)
// sanitize($input, $flags) -- input any variable, performs sanitization 
//           functions specified in flags. flags can be bitwise 
//           combination of PARANOID, SQL, SYSTEM, HTML, INT, FLOAT, LDAP, 
//           UTF8
///////////////////////////////////////
define("PARANOID", 1);
define("SQL", 2);
define("SYSTEM", 4);
define("HTML", 8);
define("INT", 16);
define("FLOAT", 32);
define("LDAP", 64);
define("UTF8", 128);

// internal function for utf8 decoding
// thanks to Jamie Pratt for noticing that PHP's function is a little 
// screwy

function my_utf8_decode($string)
{
return strtr($string, 
  "???????", 
  "SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy");
}

// paranoid sanitization -- only let the alphanumeric set through
function sanitize_paranoid_string($string, $min='', $max='')
{
  $string = preg_replace("/[^a-zA-Z0-9]/", "", $string);
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string in prep for passing a single argument to system() (or similar)
function sanitize_system_string($string, $min='', $max='')
{
  $pattern = '/(;|\||`|>|<|&|^|"|'."\n|\r|'".'|{|}|[|]|\)|\()/i'; // no piping, passing possible environment variables ($),
                           // seperate commands, nested execution, file redirection, 
                           // background processing, special commands (backspace, etc.), quotes
                           // newlines, or some other special characters
  $string = preg_replace($pattern, '', $string);
  $string = '"'.preg_replace('/\$/', '\\\$', $string).'"'; //make sure this is only interpretted as ONE argument
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return $string;
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_sql_string($string, $min='', $max='')
{
  $pattern[0] = '/(\\\\)/';
  $pattern[1] = "/\"/";
  $pattern[2] = "/'/";
  $replacement[0] = '\\\\\\';
  $replacement[1] = '\"';
  $replacement[2] = "\\'";
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, $replacement, $string);
}

// sanitize a string for SQL input (simple slash out quotes and slashes)
function sanitize_ldap_string($string, $min='', $max='')
{
  $pattern = '/(\)|\(|\||&)/';
  $len = strlen($string);
  if((($min != '') && ($len < $min)) || (($max != '') && ($len > $max)))
    return FALSE;
  return preg_replace($pattern, '', $string);
}


// sanitize a string for HTML (make sure nothing gets interpretted!)
function sanitize_html_string($string)
{
  $pattern[0] = '/\&/';
  $pattern[1] = '/</';
  $pattern[2] = "/>/";
  $pattern[3] = '/\n/';
  $pattern[4] = '/"/';
  $pattern[5] = "/'/";
  $pattern[6] = "/%/";
  $pattern[7] = '/\(/';
  $pattern[8] = '/\)/';
  $pattern[9] = '/\+/';
  $pattern[10] = '/-/';
  $replacement[0] = '&amp;';
  $replacement[1] = '&lt;';
  $replacement[2] = '&gt;';
  $replacement[3] = '<br>';
  $replacement[4] = '&quot;';
  $replacement[5] = '&#39;';
  $replacement[6] = '&#37;';
  $replacement[7] = '&#40;';
  $replacement[8] = '&#41;';
  $replacement[9] = '&#43;';
  $replacement[10] = '&#45;';
  return preg_replace($pattern, $replacement, $string);
}

// make int int!
function sanitize_int($integer, $min='', $max='')
{
  $int = intval($integer);
  if((($min != '') && ($int < $min)) || (($max != '') && ($int > $max)))
    return FALSE;
  return $int;
}

// make float float!
function sanitize_float($float, $min='', $max='')
{
  $float = floatval($float);
  if((($min != '') && ($float < $min)) || (($max != '') && ($float > $max)))
    return FALSE;
  return $float;
}

// glue together all the other functions
function sanitize($input, $flags, $min='', $max='')
{
  if($flags & UTF8) $input = my_utf8_decode($input);
  if($flags & PARANOID) $input = sanitize_paranoid_string($input, $min, $max);
  if($flags & INT) $input = sanitize_int($input, $min, $max);
  if($flags & FLOAT) $input = sanitize_float($input, $min, $max);
  if($flags & HTML) $input = sanitize_html_string($input, $min, $max);
  if($flags & SQL) $input = sanitize_sql_string($input, $min, $max);
  if($flags & LDAP) $input = sanitize_ldap_string($input, $min, $max);
  if($flags & SYSTEM) $input = sanitize_system_string($input, $min, $max);
  return $input;
}

// end of sanitize
	function preview_text($TEXT, $LIMIT, $TAGS = 0) {
	
		// TRIM TEXT
		$TEXT = trim($TEXT);
	
		// STRIP TAGS IF PREVIEW IS WITHOUT HTML
		if ($TAGS == 0) $TEXT = preg_replace('/\s\s+/', ' ', strip_tags($TEXT));
	
		// IF STRLEN IS SMALLER THAN LIMIT RETURN
		if (strlen($TEXT) < $LIMIT) return $TEXT;
	
		if ($TAGS == 0) return substr($TEXT, 0, $LIMIT) . " ...";
		else {
	
			$COUNTER = 0;
			for ($i = 0; $i<= strlen($TEXT); $i++) {
	
				if ($TEXT{$i} == "<") $STOP = 1;
	
				if ($STOP != 1) {
	
					$COUNTER++;
				}
	
				if ($TEXT{$i} == ">") $STOP = 0;
				$RETURN .= $TEXT{$i};
	
				if ($COUNTER >= $LIMIT && $TEXT{$i} == " ") break;
	
			}
	
			return $RETURN . "...";
		}
	}	
	function ProperCase($strToConvert)
	{
		$strToReturn = ucwords(strtolower($strToConvert));
		return $strToReturn;
	
	} 
	function getCountryListForCombo($GCountry='')
	{
		
		$testclass		=	new AllTables();
		$countrylist 	=	$testclass->getInfo('', "SELECT * from mstcountry");
		
		$rowcount = count($countrylist);
		
		$strCountryList = "";
		
		if ($rowcount > 0)
		{
			$currentcountry = strtolower(rtrim(ltrim($GCountry)));
			for($i=0;$i<$rowcount;$i++) 	
			{	
				$databasecountry = strtolower(rtrim(ltrim($countrylist[$i]['countryname'])));
				$compare = strcmp($currentcountry,$databasecountry);
				
				if ($compare == 0)
				{
					$strCountryList .= "<option value='".$countrylist[$i]['countryid']."-".$countrylist[$i]['countryname']."' selected='selected'>".ucwords(strtolower($countrylist[$i]['countryname']))."</option>";
				}
				else
				{	
					$strCountryList .= "<option value='".$countrylist[$i]['countryid']."-".$countrylist[$i]['countryname']."'>".ucwords(strtolower($countrylist[$i]['countryname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strCountryList;	
	}
	
	function getCityListForCombo($GCity='',$countryid='',$countryname='',$stateid='')
	{
		$testclass		=	new AllTables();
		//echo $stateid;
		if ($stateid!='')
		{
			$sqlcity = "SELECT cityid,cityname,citycode FROM mstcity WHERE stateid ='".$stateid."' ORDER BY cityorder DESC , cityname, cityid";
		}
		else if ($countryid!='')
		{
			$sqlcity = "SELECT cityid,cityname,citycode FROM mstcity WHERE countryid ='".$countryid."' ORDER BY cityorder DESC , cityname, cityid";
		}
		else if($countryname!='')
		{
			$sqlcity = "SELECT cityid,cityname,citycode FROM mstcity WHERE countryid in (Select countryid from mstcountry where countryname ='".$countryname."') ORDER BY cityorder DESC , cityname, cityid";
		}
		else
		{
			$sqlcity = "select cityid,cityname,citycode from mstcity ORDER BY cityorder DESC , cityname, cityid";
		}
		//echo $sqlcity;
		$citylist = $testclass->getInfo("",$sqlcity);
		
		$rowcount = count($citylist);
		
		$strCityList = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($GCity)==$citylist[$i]['cityname'])
				{
					$strCityList .= "<option value='".$citylist[$i]['cityid']."-".$citylist[$i]['cityname']."' selected='selected'>".ucwords(strtolower($citylist[$i]['cityname']))."</option>";
				}
				else
				{	
					$strCityList .= "<option value='".$citylist[$i]['cityid']."-".$citylist[$i]['cityname']."'>".ucwords(strtolower($citylist[$i]['cityname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strCityList;	
	}
	
	function getStateListForCombo($GStateid='',$countryid='',$countryname='')
	{
		$testclass		=	new AllTables();
		
		if ($countryid!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid ='".$countryid."' ORDER BY State asc");
		}
		else if($countryname!='')
		{
			$statelist = $testclass->getInfo("","SELECT * FROM mststate WHERE countryid in (Select countryid from mstcountry where countryname ='".$countryname."') ORDER BY State");
		}
		else
		{
			$statelist = $testclass->getInfo("","select * FROM mststate ORDER BY State");
		}
		$rowcount = count($statelist);
		
		$strstatelist = "";
		
		if ($rowcount > 0)
		{
			for($i=0;$i<$rowcount;$i++) 
			{	
				if(strtoupper($GStateid)==$statelist[$i]['State'])
				{
					$strstatelist .= "<option value='".$statelist[$i]['StateId']."-".$statelist[$i]['State']."' selected='selected'>".ucwords(strtolower($statelist[$i]['State']))."</option>";
				}
				else
				{	
					$strstatelist .= "<option value='".$statelist[$i]['StateId']."-".$statelist[$i]['State']."'>".ucwords(strtolower($statelist[$i]['State']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strstatelist;	
	}
	
	
	
	
	function getRegionsListForCombo($GRegion='')
	{
		
				$testclass		=	new AllTables();
				$regionlist 	=	$testclass->getInfo('', "SELECT * from mstregion order by regionname asc");
				
				$rowcount = count($regionlist);
				
				$strregionlist = "";
				
				if ($rowcount > 0)
				{
					$currentregion = strtolower(rtrim(ltrim($GRegion)));
					for($i=0;$i<$rowcount;$i++) 	
					{	
						$databaseregion = strtolower(rtrim(ltrim($regionlist[$i]['regionname'])));
						$compare = strcmp($currentregion,$databaseregion);
						
						if ($compare == 0)
						{
							$strregionlist .= "<option value='".$regionlist[$i]['regionid']."-".$regionlist[$i]['regionname']."' selected='selected'>".ucwords(strtolower($regionlist[$i]['regionname']))."</option>";
						}
						else
						{	
							$strregionlist .= "<option value='".$regionlist[$i]['regionid']."-".$regionlist[$i]['regionname']."'>".ucwords(strtolower($regionlist[$i]['regionname']))."</option>";
						}
					}
				}
				unset($testclass);
				return $strregionlist;	
	}
	function getThemeListForCombo($GTheme='')
	{
		
				$testclass		=	new AllTables();
				$themelist 	=	$testclass->getInfo('', "SELECT * from msttheme order by themename asc");
				
				$rowcount = count($themelist);
				
				$strTheme = "";
				
				if ($rowcount > 0)
				{
					$currenttheme = strtolower(rtrim(ltrim($GTheme)));
					for($i=0;$i<$rowcount;$i++) 	
					{	
						$databasetheme = strtolower(rtrim(ltrim($themelist[$i]['themename'])));
						$compare = strcmp($currenttheme,$databasetheme);
						
						if ($compare == 0)
						{
							$strTheme .= "<option value='".$themelist[$i]['themeid']."-".$themelist[$i]['themename']."' selected='selected'>".ucwords(strtolower($themelist[$i]['themename']))."</option>";
						}
						else
						{	
							$strTheme .= "<option value='".$themelist[$i]['themeid']."-".$themelist[$i]['themename']."'>".ucwords(strtolower($themelist[$i]['themename']))."</option>";
						}
					}
				}
				unset($testclass);
				return $strTheme;	
	}
	function SelectCityName($cityname)
	{
	
			$testclass		=	new AllTables();
			$sql			=	"SELECT cityname from mstcity where cityname like '%$cityname%'";
			$citylist 		=	$testclass->getInfo('',$sql);
			if(is_array($citylist))
			{
					//$cityname	=	$citylist[0]['cityname'];
					//return $cityname;
					return $citylist;
			}
			
	}
	function CityName($cityid)
	{
	
			$testclass		=	new AllTables();
			$sql			=	"SELECT cityname from mstcity where cityid='$cityid'";
			$citylist 		=	$testclass->getInfo('',$sql);
			if(is_array($citylist))
			{
					$cityname	=	$citylist[0]['cityname'];
					return $cityname;
			}
	}
	function CountryName($countryid)
	{
	
			$testclass		=	new AllTables();
			$sql			=	"SELECT countryname from mstcountry where countryid='$countryid'";
			$countrylist 		=	$testclass->getInfo('',$sql);
			if(is_array($countrylist))
			{
					$countryname	=	$countrylist[0]['countryname'];
					return $countryname;
			}
	}
	function RegionName($regionid)
	{
	
			$testclass		=	new AllTables();
			$sql			=	"SELECT regionname from  mstregion where regionid='$regionid'";
			$Regionlist 		=	$testclass->getInfo('',$sql);
			if(is_array($Regionlist))
			{
					$regionname	=	$Regionlist[0]['regionname'];
					return $regionname;
			}
	}
	function LocationName($locationid)
	{
	
			$testclass				=	new AllTables();
			$sqlLocation			=	"SELECT locationname from  mstlocation where locationid='$locationid'";
			$LocationList 			=	$testclass->getInfo('',$sqlLocation);
			if(is_array($LocationList))
			{
					$locationname	=	$LocationList[0]['locationname'];
					//unset($testclass);
					return $locationname;
			}
	}
	function ThemeName($themeid)
	{
	
			$testclass			=	new AllTables();
			$sqlthemeid			=	"SELECT themename from  msttheme where themeid='$themeid'";
			$themelist 			=	$testclass->getInfo('',$sqlthemeid);
			if(is_array($themelist))
			{
					$themename	=	$themelist[0]['themename'];
					return $themename;
					unset($testclass);
			}
	}
	function PackageName($tourpackageid)
	{
	
			$testclass			=	new AllTables();
			$sqlpack			=	"SELECT * from  GTR_tourpackages where tourpackageid='$tourpackageid'";
			$packlist 			=	$testclass->getInfo('',$sqlpack);
			if(is_array($packlist))
			{
					$packname	=	$packlist[0]['tourpackagetitle'];
					return $packname;
					unset($testclass);
			}
	}
		function package_pdffilename($tourpackageid)
	{
	
			$testclass			=	new AllTables();
			$sqlpack			=	"SELECT pdf_filepath from  GTR_tourpackages where tourpackageid='$tourpackageid'";
			$packlist 			=	$testclass->getInfo('',$sqlpack);
			if(is_array($packlist))
			{
					$packname	=	$packlist[0]['pdf_filepath'];
					return $packname;
					unset($testclass);
			}
	}
	function PackageListForHomePage($regionid,$countryid,$themeid,$pagename,$numberofday='')
	{
			$testclass		=		new AllTables();
			$numberofnights	=	$numberofday-1;
			
			//Condition starts here for serch.php
		if($pagename=='search.php')	
		{
			if($regionid!="")
				{
					 //$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}
			else if($countryid!="")
				{
					 //$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.countryid='$countryid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.countryid='$countryid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}
			else if($themeid!="")
				{
					 //$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}			
			else
				{	
				$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
		
			/*if($regionid!="" && $countryid!="" && $themeid!="")
			{
					$packsql		=		"SELECT a.tourpackageid, a.tourpackagedesc,a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and a.countryid='$countryid' and a.themeid='$themeid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid!="" && $countryid!="" && $themeid=="")
			{
					$packsql		=		"SELECT a.tourpackageid, a.tourpackagedesc,a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and a.countryid='$countryid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid!="" && $countryid=="" && $themeid=="")
			{
				$packsql		=		"SELECT a.tourpackageid, a.tourpackagedesc,a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid=="" && $countryid!="" && $themeid!="")
			{
				$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and a.countryid='$countryid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid=="" && $countryid!="" && $themeid=="")
			{
					$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where  a.countryid='$countryid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid=="" && $countryid=="" && $themeid!="")
			{
				$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and noofnights='$numberofnights'  and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			else if($regionid!="" && $countryid=="" && $themeid!="")
			{
					$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and a.regionid='$regionid' and noofnights='$numberofnights' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
		else
			{	
				$packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}*/
		}	
			
			else
			{
					$packsql		=		"SELECT a.tourpackageid, a.tourpackagetitle,a.countryid,a.tourpackagedesc, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.packagedeleted='0' and isspecialpackage='1' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
			}
			
			$packagelist	=		$testclass->getInfo('',$packsql);
			$totalpack	=	count($packagelist);
			if($totalpack>0)
			{
					$totalpack	=	count($packagelist);
					for($i=0;$i<$totalpack;$i++)
					{
							$tourpackageid				=		$packagelist[$i]['tourpackageid'];
							$tourpackagetitle			=		preview_text($packagelist[$i]['tourpackagetitle'],'16');
							$tourpackagedesc			=		preview_text($packagelist[$i]['tourpackagedesc'],'60');
							$countryid					=		CountryName($packagelist[$i]['countryid']);
							$itineraryphotopath			=		$packagelist[$i]['itineraryphotopath'];
							if($itineraryphotopath!="")
							{
									 $imagesrc						=	PACKAGE_IMAGE.'thumb/'.$itineraryphotopath;
							}
							else
							{
									 $imagesrc						=	IMAGE_DIR.'mail_photo.jpeg';
							}
							$url						=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
							$moreurl					=		IMAGE_DIR.'gree_arr.jpg';
							if($pagename=='search.php')	
							{
							
											$strPackage		.=		'<div class="packages">';
											$strPackage		.=		'<div class="packageimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="181" height="120" class="imagesborder" /></a></div>';
											$strPackage		.=		'<div class="packagehading blacktwo"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
											$strPackage		.=		'<div class="packagedetails blacknormal">"'.$tourpackagedesc.'"';
											$strPackage		.=		'</div>';
											$strPackage		.=		'<div class="more "> <a class="readmore1" href="'.$url.'">...More</a></div>';
											$strPackage		.=		'</div>';
							}
							else
							{
									$strPackage					.=		'<div class="specialpackagesinner">';
									$strPackage					.=		'<div class="specialpackageshading whitetext"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
									$strPackage					.=		'<div class="specialpackagesimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="145" height="108"  class="imagesborder2"/></a></div>';
									$strPackage					.=		'<div class="specialpackagesimgmore"><a  class="whitetext" href="'.$url.'">'.$countryid.' >></a></div>';
									$strPackage					.=		'</div>';
							}
							
					}
					return $strPackage;
			}
			else
			{
				$CountryName	=	ProperCase(CountryName($countryid));
				$RegionName		=	ProperCase(RegionName($regionid));
				$ThemeName		=	ProperCase(ThemeName($themeid));
				
				$strPackage		.=		'<div class="panelgroup-info-holder">';
				$strPackage		.=		'<p class="redtext"><strong>No Related Package Found</strong></p><br/>See Other Packege For '.$CountryName. $RegionName.$ThemeName;
				$strPackage		.=		'</div>';
				//default detail
			if($regionid!="")
				{
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}
			if($countryid!="")
				{
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.countryid='$countryid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}
			if($themeid!="")
				{
					 $packsql		=		"SELECT a.tourpackageid,a.tourpackagedesc, a.tourpackagetitle,a.countryid, b.itineraryphotopath FROM GTR_tourpackages a left JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.themeid='$themeid' and  a.packagedeleted='0' group by a.tourpackagetitle ORDER BY a.tourpackageid DESC";
				}	
			$packagelist	=		$testclass->getInfo('',$packsql);
			$totalpack	=	count($packagelist);
			if($totalpack>0)
			{
					$totalpack	=	count($packagelist);
					for($i=0;$i<$totalpack;$i++)
					{
							$tourpackageid				=		$packagelist[$i]['tourpackageid'];
							$tourpackagetitle			=		preview_text($packagelist[$i]['tourpackagetitle'],'16');
							$tourpackagedesc			=		preview_text($packagelist[$i]['tourpackagedesc'],'60');
							$countryid					=		CountryName($packagelist[$i]['countryid']);
							$itineraryphotopath			=		$packagelist[$i]['itineraryphotopath'];
							if($itineraryphotopath!="")
							{
									 $imagesrc						=	PACKAGE_IMAGE.'thumb/'.$itineraryphotopath;
							}
							else
							{
									 $imagesrc						=	IMAGE_DIR.'mail_photo.jpeg';
							}
							$url						=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
							$moreurl					=		IMAGE_DIR.'gree_arr.jpg';
							if($pagename=='search.php')	
							{
							
											$strPackage		.=		'<div class="packages">';
											$strPackage		.=		'<div class="packageimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="181" height="120" class="imagesborder" /></a></div>';
											$strPackage		.=		'<div class="packagehading blacktwo"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
											$strPackage		.=		'<div class="packagedetails blacknormal">"'.$tourpackagedesc.'"';
											$strPackage		.=		'</div>';
											$strPackage		.=		'<div class="more "> <a class="readmore1" href="'.$url.'">...More</a></div>';
											$strPackage		.=		'</div>';
							}
							else
							{
									$strPackage					.=		'<div class="specialpackagesinner">';
									$strPackage					.=		'<div class="specialpackageshading whitetext"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
									$strPackage					.=		'<div class="specialpackagesimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="145" height="108"  class="imagesborder2"/></a></div>';
									$strPackage					.=		'<div class="specialpackagesimgmore"><a  class="whitetext" href="'.$url.'">'.$countryid.' >></a></div>';
									$strPackage					.=		'</div>';
							}
							
					}
				}
				return $strPackage;
			}
	}
	function DestinationListForHomePage()
	{
			$testclass		=		new AllTables();
			$destsql		=		"select * from mstlocation order by locationname";
			$DestList		=		$testclass->getInfo('',$destsql);
			if(is_array($DestList))
			{
					$totaldestination	=	count($DestList);
					for($i=0;$i<$totaldestination;$i++)
					{
							$locationid				=		$DestList[$i]['locationid'];
							$locationname			=		$DestList[$i]['locationname'];
							
							$url						=		DOC_ROOT.'locations.php?locationid='.$locationid;
							
							//$strDestination					.=		'<li><a href="'.$url.'" id="current">'.$locationname.'</a></li>';
							$strDestination					.=		'<li><a href="'.$url.'">'.$locationname.'</a></li>';
							
							
					}
					return $strDestination;
			}
			
	}
	function RelatedPackageForLacation($locationid)
	{
			$testclass		=		new AllTables();
			if($locationid!='')
			{
					 $locationname			=		LocationName($locationid);
					 $packagesql			=		"select regionid from mstlocation where locationid='$locationid'";
			}
			$Detaillist		=		$testclass->getInfo('',$packagesql);
			if(is_array($Detaillist))
			{
					$totaldestination	=	count($Detaillist);
					for($i=0;$i<$totaldestination;$i++)
					{
							$regionid				=		$Detaillist[$i]['regionid'];
							//$relatedpacksql			=		"select * from GTR_tourpackages where regionid='$regionid'";
							$relatedpacksql			=		"SELECT a.tourpackageid, a.tourpackagetitle, b.itineraryphotopath FROM GTR_tourpackages a INNER JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and a.packagedeleted='0' group by a.tourpackagetitle";
							//echo $relatedpacksql;
							$TourPackList			=		$testclass->getInfo('',$relatedpacksql);
							if(is_array($TourPackList))
							{
									
									$totalpacklist			=	count($TourPackList);
									for($i=0;$i<$totalpacklist;$i++)
									{
											$tourpackageid				=	$TourPackList[$i]['tourpackageid'];
											$tourpackagetitle			=	$TourPackList[$i]['tourpackagetitle'];
											$itineraryphotopath			=	$TourPackList[$i]['itineraryphotopath'];
											if($itineraryphotopath!="")
											{
													 $imagesrc						=	PACKAGE_IMAGE.'thumb/'.$itineraryphotopath;
											}
											else
											{
													 $imagesrc						=	IMAGE_DIR.'mail_photo.jpeg';
											}
											$url						=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
											$moreurl					=		IMAGE_DIR.'gree_arr.jpg';
											//$img					=		IMAGE_DIR.'lo_img1.jpg';
											$strPackList		.=		'<div class="locationspackagesinner">';
											$strPackList		.=		'<div class="locationspackagesname redtext"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
											$strPackList		.=		'<div class="locationspackagesimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="180" height="126" /></a></div>';
											$strPackList		.=		'<div class="locationspackagesmore"><a  class="redtext"href="'.$url.'">More<img src="'.$moreurl.'" width="15" height="11" /></a></div>';
											$strPackList		.=		'</div>';
									}
										return $strPackList;
							}
							else
							{
									
									$strPackList		.=		'<div class="panelgroup-info-holder">';
									$strPackList		.=		'<p class="redtext"><strong>No package are available for '.$locationname.'</strong></p>';
									$strPackList		.=		'</div>';
									return $strPackList;
							}
					}
			}
	}
	function RaletedTourPackageListForHomePage($regionid)
	{
			$testclass			=	new AllTables();
			$sqltourpack		=	"SELECT a.tourpackageid,a.tourpackagetitle,b.itineraryphotopath,a.tourpackagedesc FROM GTR_tourpackages a INNER JOIN GTR_tourpackageItinerary b ON b.tourpackageid = a.tourpackageid where a.regionid='$regionid' and a.packagedeleted='0' group by a.tourpackagetitle order by a.tourpackageid desc";
			//echo $sqltourpack;
			$TourPackList		=	$testclass->getInfo('',$sqltourpack);
			if(is_array($TourPackList))
			{
						$totalrow		=		count($TourPackList);
						for($i=0;$i<$totalrow;$i++)
						{
							$tourpackageid				=	$TourPackList[$i]['tourpackageid'];
							$tourpackagetitle			=	preview_text($TourPackList[$i]['tourpackagetitle'],15);
							$itineraryphotopath			=	$TourPackList[$i]['itineraryphotopath'];
							if($itineraryphotopath!="")
							{
									 $imagesrc						=	PACKAGE_IMAGE.'thumb/'.$itineraryphotopath;
							}
							else
							{
									 $imagesrc						=	IMAGE_DIR.'mail_photo.jpeg';
							}
							$tourpackagedesc			=		preview_text($TourPackList[$i]['tourpackagedesc'],50);
							$url						=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
							$moreurl					=		IMAGE_DIR.'gree_arr.jpg';
							//$img					=		IMAGE_DIR.'lo_img1.jpg';
							
							
							$strTourPackList		.=		'<div class="packages">';
							$strTourPackList		.=		'<div class="packageimg"><a href="'.$url.'"><img src="'.$imagesrc.'" width="181" height="120" class="imagesborder" /></a></div>';
							$strTourPackList		.=		'<div class="packagehading blacktwo"><a href="'.$url.'">'.$tourpackagetitle.'</a></div>';
							$strTourPackList		.=		'<div class="packagedetails blacknormal">"'.$tourpackagedesc.'"';
							$strTourPackList		.=		'</div>';
							$strTourPackList		.=		'<div class="more "> <a class="readmore1" href="'.$url.'">...More</a></div>';
							$strTourPackList		.=		'</div>';
					}
					return $strTourPackList;
			}
			else
			{			
			
						$strTourPackList		.=		'<div class="panelgroup-info-holder">';
						$strTourPackList		.=		'<p class="redtext"><strong>No Related Package Found</strong></p>';
						$strTourPackList		.=		'</div>';
						//$strTourPackList			=	"No Related Package Found";
						return $strTourPackList;
			}
	}
	function GalleryPhotoForHomePage()
	{
				$testclass				=	new AllTables();
				$galleryphotolist		=	$testclass->getInfo('',"SELECT itineraryphotopath   FROM `GTR_tourpackageItinerary` where itineraryphotopath!='' order by itineraryphotopath desc");
			if(is_array($galleryphotolist))
			{
				$rowcount		=		count($galleryphotolist);
				
				for($i=0;$i<$rowcount;$i++)
				{
						$photoimagepath	=	$galleryphotolist[$i]['itineraryphotopath'];
						$url			=	DOC_ROOT.'gallery.php';
						$galleryimg		=	PACKAGE_IMAGE.'thumb/'.$photoimagepath;
						$biggallery		=	PACKAGE_IMAGE.$photoimagepath;
						$galleryphoto				.=	'<div id="gallery" >';
						$galleryphoto	.=	'<div class="packages">';
                        $galleryphoto	.=	'<div class="packageimg"><a href="'.$biggallery.'"><img src="'.$galleryimg.'" width="181" height="120" class="imagesborder"/></a></div>';
                       	$galleryphoto	.=	'</div>';
						$galleryphoto	.=	'</div>';
						
						
				}
				
				return $galleryphoto;
			}
			else
			{
				$galleryphoto	=	"Gallery Photo Empty";
				return $galleryphoto;
			}
	}
	function GalleryVedioForHomePage()
	{
				$testclass				=	new AllTables();
				$galleryVediolist		=	$testclass->getInfo('',"SELECT PackageVideotitle,videolink,tourpackageid FROM `GTR_tourpackages` where videolink!=''");
				//echo "SELECT videolink FROM `GTR_tourpackages` where videolink!=''";
			if(is_array($galleryVediolist))
			{
				$rowcount		=		count($galleryVediolist);
				
				for($i=0;$i<$rowcount;$i++)
				{
						$Videogepath	=	$galleryVediolist[$i]['videolink'];
						//$url			=	DOC_ROOT.'video.php';
						//$galleryimg		=	$Videogepath;
						//$biggallery		=	$photoimagepath;
						//you tube vedio 
						if ($Videogepath!=''){
								$jutjub = new YouTube($Videogepath);
								//$showvideo = $jutjub->EmbedVideo();
								$showimage = $jutjub->ShowImg();
							}
		
						
						
						$galleryVedio	.=	'<div class="vedioinner">';
						//$galleryVedio	.=	'<div class="vedioleft">'.$showvideo.'</div>';
                        //$galleryVedio	.=	'<div class="vedioright">'.$showvideo.'</div>';
						$galleryVedio	.=	'<div class="vedioleft"><a href="'.DOC_ROOT.'video_details.php?videoid='.$galleryVediolist[$i]['tourpackageid'].'">'.$showimage.'<br /><strong class="lightblue">'.$galleryVediolist[$i]['PackageVideotitle'].'</strong></a></div>';
						$galleryVedio	.=	'<div class="vedioright"><a href="'.DOC_ROOT.'video_details.php?videoid='.$galleryVediolist[$i]['tourpackageid'].'">'.$showimage.'<br /><strong class="lightblue">'.$galleryVediolist[$i]['PackageVideotitle'].'</strong></a></div>';
                       	$galleryVedio	.=	'</div>';
						
						
				}
				
				return $galleryVedio;
			}
			else
			{
				$galleryVedio	=	"Gallery Vedio Empty";
				return $galleryVedio;
			}
	}
	function FooterPageLink($pagevalue)
		{
					//PageValue means, where to display in header or footer
					$footer			=	new AllTables();
					if($pagevalue!='')
					{
								$footersql		=	"Select * from mstpages where  isapproved='1' and pagecategory='0' order by pagename asc limit 0,3";
					}
					else
					{
								$footersql		=	"Select * from mstpages where isapproved='1' order by pagename asc limit 0,5";							
					}
					$pagenamelist	=	$footer->getInfo('',$footersql);
					if(is_array($pagenamelist))
					{
							$pagecount		=	count($pagenamelist);
							$pagecategory	=	'';
							for($i=0;$i<$pagecount;$i++)
							{
									$pageid				=		$pagenamelist[$i]['pageid'];
									$pagename			=		ProperCase($pagenamelist[$i]['pagename']);
									$pagelink			=		$pagenamelist[$i]['pagelink'];
									$pagecategory		=		$pagenamelist[$i]['pagecategory'];
									$url				=		DOC_ROOT.'pages/'.$pagelink.'.htm';
									$selectedlink		=		'/pages/index.php?pagename='.$pagename.'';
									if($pagevalue=='header')
									{
											// check if there are sub pages under this page
											$subpagesql = "select * from mstpages where pagecategory='$pageid' and isapproved='1'";
											$subpageslist	=	$footer->getInfo('',$subpagesql);
											if ($subpageslist)
											{
												$subpagecount = count($subpageslist);
												$footerpages		.=		'<li><a href="#" >'.$pagename.'</a>';
												$footerpages		.=		'<ul>';
												for ($j=0;$j< $subpagecount;$j++)
												{
														$subpagelink			=	$subpageslist[$i]['pagelink'];
														$subpageurl				= 	DOC_ROOT.'pages/'.$subpagelink.'.htm';
														$footerpages			.=	'<li><a href="'.$subpageurl.'">'.$subpageslist[$j]['pagename'].'</a></li>';
												}
														$footerpages			.=	'</ul></li>';
											}
											else
											{
												$footerpages		.=		'<li><a href="'.$url.'" >'.$pagename.'</a></li>';
											}	
									}
									else
									{
											$footerpages		.=		'<a href="'.$url.'" class="whitefooter">'.$pagename.'</a>   |';
									}
								
							}
							return $footerpages;
							
					}
		}
	function BannerListForHome()
	{
					$banner			=	new AllTables();
					$bannersql		=	"Select * from mstbanner order by bannerid desc limit 0,5";
					$bannerlist	=	$banner->getInfo('',$bannersql);
					if(is_array($bannerlist))
					{
						$rowcount	=	count($bannerlist);
						for($i=0;$i<$rowcount;$i++)
						{
								$bannerid		=		$bannerlist[$i]['bannerid'];
								$bannername		=		$bannerlist[$i]['bannername'];
								$image			=		$bannerlist[$i]['image'];
								//$imageval		=		($image=='')?IMAGE_DIR.'mail_photo.jpeg':BANNER_IMAGE.$image;	
								//$strBanner		.=		'<img src="'.$imageval.'" width="1200" height="400" />';
								//echo "<br>".BANNER_IMAGE;
								$imageval		=		($image=='')?IMAGE_DIR.'mail_photo.jpeg':BANNER_IMAGE.$image;	
								$strBanner		.=		'<div style="display: none;">';
								$strBanner		.=		'<img data-u="image" src="'.$imageval.'" class="img-responsive" />';
								$strBanner		.=		'</div>';
						}	
						return $strBanner;
						unset($banner);	
					}
	}
	function Attachement($tourpackageid)
	{
	
			
			$testclass			=	new AllTables();
			$attach				=	"SELECT pdf_filepath from  GTR_tourpackages where tourpackageid='$tourpackageid'";
			$attachlist 		=	$testclass->getInfo('',$attach);
			if(is_array($attachlist))
			{
					$pdf_filepath	=	$attachlist[0]['pdf_filepath'];
					return $pdf_filepath;
					unset($testclass);
			}
	}
	function GetTestimonial($testimonialid)
	{
					$test			=	new AllTables();
					if($testimonialid!='')
					{
							$testsql		=	"Select * from  msttestimonial where testimonialid='$testimonialid' order by testimonialid desc limit 0,2"; 
					}
					else
					{
							$testsql		=	"Select * from  msttestimonial order by testimonialid desc limit 0,2"; 
					}
					$testlist		=	$test->getInfo('',$testsql);
					if(is_array($testlist))
					{
						$rowcount	=	count($testlist);
						for($i=0;$i<$rowcount;$i++)
						{
								$testimonialid					=		$testlist[$i]['testimonialid'];
								$testimonial					=		$testlist[$i]['testimonial'];
								$testimonialbyclientname		=		ProperCase($testlist[$i]['testimonialbyclientname']);
								$testimonialdate				=		date("d M Y",strtotime($testlist[$i]['testimonialdate']));
								
								$strTestimonial		.=		'<div class="testimonialstext">'.$testimonial.'';
								//$strTestimonial		.=		'"'.trim($testimonial).'"';
								$strTestimonial		.=		'<br />';
								$strTestimonial		.=		'</div>';
								$strTestimonial		.=		'<div class="testimonialsname blacknormal2">'.$testimonialbyclientname.'<br />';
								$strTestimonial		.=		'Date :&nbsp;'.$testimonialdate.'';
                  				$strTestimonial		.=		'</div>';
								
						}	
						return $strTestimonial;
						unset($test);	
					}
					else
					{	
							$strTestimonial		=	"There are no testimonial";
							return $strTestimonial;
					}
	}
	function HeaderSubMenuListForRegion($regionid)
	{
			$menu			=	new AllTables();
			$menulist		=	$menu->getInfo('',"Select tourpackageid,tourpackagetitle from GTR_tourpackages where regionid='$regionid' and packagedeleted='0' order by tourpackageid limit 0,20 ");
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$tourpackageid			=		$menulist[$i]['tourpackageid'];
							$tourpackagetitle		=		$menulist[$i]['tourpackagetitle'];
							$link					=		DOC_ROOT.'packagedetails.php?tourpackageid='.$tourpackageid;
							$subMenu				.=		'<li><a href="'.$link.'">'.$tourpackagetitle.'</a></li>';
							
					}
					return $subMenu;
					
			}
			/*else
			{
						$subMenu				.=		'<li>Not Found</li>';
						return $subMenu;
			}*/
	}
	
	function headermenu()
	{
		$testclass			=	new AllTables();
		$pagename			=	$_GET['pagename'];	
		//$sql				=	"select * from mstpages where pagelink like '$pagename%' and isapproved='1'";
		$sql				   =	"select * from GTR_tourpackages where packagedeleted='0' order by tourpackagelocation,tourpackagetitle limit 0,8"; // 
		//echo $sql;
		$pagelist			=	$testclass->getInfo('',$sql);
		if ($pagelist)
		{
		    $rowcount 			=	count($pagelist);
		}
		return $pagelist;
	}
	
	function getPackagesForHomePage()
	{
		$currentdate  = date('Y-m-d');
		$testclass			=	new AllTables();
		//$sql				=	"select *,(select availableslots from GTR_tourpackageschedule where GTR_tourpackageschedule.tourpackageid = GTR_tourpackages.tourpackageid and GTR_tourpackageschedule.departuredate = GTR_tourpackages.packagevalidfromdate limit 0,1)availableslots from GTR_tourpackages order by packagerating desc limit 0,8";
		
		$sql				=	"select * from GTR_tourpackages where packagedeleted='0' and packagestatus = 1 and packagevalidfromdate >= '$currentdate' order by packagevalidfromdate "; //,GTR_tourpackages.packagedispfromdate,tourpackagelocation,tourpackagetitle
		//echo $sql;
		$packagelist			=	$testclass->getInfo('',$sql);
		return $packagelist;	
	}	
	function scrolldivpackagelistNew($packagelist,$noofpackages='4')
	{
	        if (is_array($packagelist))
		    {
		        echo $rowcount 			=	count($packagelist);
		    }
		    $subsubpackageactiveitemstartdiv ='<div class="item active">
												<div class="row" >';
												
		    $subsubpackageactiveitemenddiv='</div>
											</div>';
		
		    $subsubpackagehideitemstartdiv	= '<div class="item">
												<div class="row">';
												
		    $subsubpackagehideitemenddiv	= '</div>
											   </div>';
		
			if(is_array($packagelist))
			{
				$packagecount = count($packagelist);
				$rowcount = ($rowcount > $noofpackages)?$noofpackages:$rowcount;
				
				for($i=0;$i<$rowcount;$i++)
				{
					$packagerating = 0;
					$tourpackageid				=		$packagelist[$i]['tourpackageid'];
					$tourpackagetitle			=		preview_text($packagelist[$i]['tourpackagetitle'],27);
					$tourpackagetitleURL		=		cleanURL(preview_text($packagelist[$i]['tourpackagetitle'],50));
					
					$readmorephotothumb			=		$packagelist[$i]['readmorephotothumb'];
					$homepagephotothumb			=		$packagelist[$i]['homepagephotothumb'];
					$packagevalidfromdate		=		($packagelist[$i]['packagevalidfromdate']!='0000-00-00')?date('d M Y',strtotime($packagelist[$i]['packagevalidfromdate'])):'';
					$packagevalidtodate			=		($packagelist[$i]['packagevalidtodate']!='0000-00-00')?date('d M Y',strtotime($packagelist[$i]['packagevalidtodate'])):'';
					$noofnights					=		$packagelist[$i]['noofnights'];
					$noofdays					=		$packagelist[$i]['noofdays'];
					$tourstrikethroughcostfrom	=		format_number($packagelist[$i]['tourstrikethroughcostfrom']);
					$tourcostfrom				=		format_number($packagelist[$i]['tourcostfrom']);
					$addionaltourcost 		=		format_number($packagelist[$i]['addionaltourcost']);
					$addionaltourcost 		=		str_replace(".00","",$addionaltourcost);
					$addionaltourcost 		=		str_replace("0","",$addionaltourcost);
					$tourcostcurrency = $packagelist[$i]['tourcostcurrency'];
					$addionaltourcostcurrency = " + ".$packagelist[$i]['addionaltourcostcurrency'];
					$servicetaxpercentage 	=		format_number($pagelist[$i]['servicetaxpercentage']);
					$servicetaxamount			=		format_number($pagelist[$i]['servicetaxamount']);		
					$tourpackageshortdesc		=		strip_tags($packagelist[$i]['tourpackageshortdesc'],200);
					$link						=		DOC_ROOT.'package-'.$tourpackageid.'-'.$tourpackagetitleURL.'-.htm';
					$isspecialpackage			=		$packagelist[$i]['isspecialpackage'];
					$availableslots				= 		$packagelist[$i]['availableslots'];
					$packagerating 				= 		$packagelist[$i]['packagerating'];
					
					$packagevalidfromdatecalc	=		$packagelist[$i]['packagevalidfromdate'];
					$tourcostfromcalc			=		$packagelist[$i]['tourcostfrom'];
										
					$tourstrikethroughcostfrom = str_replace(".00","",$tourstrikethroughcostfrom);
					
					if($tourstrikethroughcostfrom > 0) 
					{
						$strikecondition='<strike>INR  '.$tourstrikethroughcostfrom.'</strike>';
					}else{
						$strikecondition = "";
					}
					
					$tourcostfrom = str_replace(".00","",$tourcostfrom);
					
					if($addionaltourcost <= 0)
					{
						$addionaltourcost = "";
						$addionaltourcostcurrency = "";
					}
					
					if($homepagephotothumb>'')
					{
						 //$pageimagepath1				=	LOGO_THUMB_IMAGE.$pageimagepath;
						   $packageimagepath1				=	PACKAGE_IMAGE.$homepagephotothumb;
					}
					else
					{
						   $packageimagepath1				=	IMAGE_DIR.'noplayerimg.jpeg';
					}
					
					if($isspecialpackage == 1)
					{
							$specialofferdiv 	=	'<div class="badge_save">Special Offer</div>';
					}
					else
					{
							$specialofferdiv	=	'';
					}
					
					if($availableslots=="" || $availableslots=="0" )
					{
						$availableslots = 'Limited Seats';
					} 
					else 
					{
						$availableslots = $availableslots.' Booked';
					} 
					
				
					
					
					
					$sqlText = 'SELECT * FROM GTR_tourpackagediscount where tourpackageid='.$tourpackageid;
					//echo $sqlText;
					// temporary blocked by rajiv on 6th feb 2020 to check loading of home
					// after blocking this query page is working fine.
					// need to check the below query and remove it from the loop
					//$productlisting = $testclass->getInfo('', $sqlText);//mysqli_query($sqlText) or die(mysqli_error());
					//print_r($productlisting);
					$DiscountedPackageCost = "";
					if(is_array($productlisting))
					{
						//print_r($productlisting);
						$productrowcount = count($productlisting);
						for($j=0;$j<$productrowcount;$i++)
						{
							$tourpackagediscountid	   = $productlisting[$j]['tourpackagediscountid'];
							$tourpackageid		         = $productlisting[$j]['tourpackageid'];

							$packagetitle					= $productlisting[$j]['tourpackagetitle'];
							$tourpackagetitleURL			=		cleanURL(preview_text($productlisting[$i]['tourpackagetitle'],50));
							$slot1day1						= $productlisting[$j]['slot1day1'];
							$slot1day2						= $productlisting[$j]['slot1day2'];
							$slot2day1						= $productlisting[$j]['slot2day1'];
							$slot2day2						= $productlisting[$j]['slot2day2'];
							$slot3day1						= $productlisting[$j]['slot3day1'];
							$slot3day2						= $productlisting[$j]['slot3day2'];
							$slot1percentage				= $productlisting[$j]['slot1percentage'];
							$slot2percentage				= $productlisting[$j]['slot2percentage'];
							$slot3percentage				= $productlisting[$j]['slot3percentage'];
							
						
						
						}					
					
                        $date0  = date('Y-m-d');
                        $date1 = new DateTime($date0);
                        $date2 = new DateTime($packagevalidfromdatecalc);
                        $interval = $date1->diff($date2);
                        //echo "difference " . $interval->y . " years, " . $interval->m." months, ".$interval->d." days "; 

                        // shows the total amount of days (not divided into years, months and days like above)
                        //echo "difference " . $interval->days . " days ";

                        //echo "<br>Date one ".date_format($date1, 'Y-m-d');
                        //echo "<br>Date two ".date_format($date2, 'Y-m-d');

                        $datedif =  $interval->days;
                        //echo $datedif;
                        //echo "<br>difference " . $datedif . " days ";
                        $percent=0;
                        if($datedif > $slot1day1 && $datedif < $slot1day2 ) 
                        {
                            //echo '<br>30-40';
                            $percent=$slot1percentage;
                        }
                        elseif($datedif > $slot2day1 && $datedif < $slot2day2) 
                        {
	                        //echo '<br>46-60';
	                        $percent=$slot2percentage;
                        }
                        elseif($datedif > $slot3day1 && $datedif < $slot3day2) 
                        {
	                        //echo '<br>61-90';
	                        $percent=slot3percentage;
                        }

                        $PackageCost = $tourcostfromcalc;
                        //echo "<br>Package Cost ".$PackageCost;
                        //echo "<br>percent ".$percent;

                        $r1 = $percent;

                        $b1 = (+$PackageCost)*(+$percent);
                        $b2 = (+$b1)/100;
                        $DiscountedPackageCost = (+$PackageCost)-(+$b2);

                        //echo "<br>Discounted Package Cost ".$DiscountedPackageCost;


                    }
                        //echo "<br>Discounted Package Cost ".$DiscountedPackageCost;

                    if ($DiscountedPackageCost == "" )
                    {
	                    $DiscountedPackageCost = $tourcostfromcalc;
                    }
                        $DiscountedPackageCost = sanitize(format_number($DiscountedPackageCost),SQL);
                        $DiscountedPackageCost = str_replace(".00","",$DiscountedPackageCost);	

                        $price = '';
                    if($DiscountedPackageCost > 0) 
                    {
	                    $price=''.$tourcostcurrency.' '.$DiscountedPackageCost.''.$addionaltourcostcurrency.' '.$addionaltourcost.'';
                    }
                    
					$commondiv .= '              
						<div class="col-md-12 col-sm-12 col-xs-12 p0">						
				            <div style="background:#fff ; padding:5px;height:430px;">
					        <div class="tour_title_home">
					            '.$specialofferdiv.'
							    <div class="img_container">
								    <a href ="'.$link.'"><img src="'.$packageimagepath1.'" class="" alt=""></a>
							    </div>
					        </div>
				            <div class="tour_title">
						        <a href ="'.$link.'"><h3>'.$tourpackagetitle.'</h3></a>
						        <div class="tour_from">'.$packagevalidfromdate.' - '.$packagevalidtodate.'
                                </div><!-- end rating -->
						        <div class="discount_price">'.$strikecondition.'</div>
                                <div class="day_nights">'.$noofdays.'D / '.$noofnights.'N
						        </div>
						        <div class="after_discount">
                                '.$price.'
                                </div>
						        <div class="clearfix"></div>
						        <div style="border-top:1px solid #eee; margin-top:4px;">
						        <div class="">
						            <div class="">';                                           
						        //$commondiv .=  '<div class="rateit" data-rateit-value="'.intval($packagerating).'" data-rateit-ispreset="true" data-rateit-readonly="true"></div>';
						      //rating new code add 19-01-2024 start   
						        $commondiv .=  '<fieldset class="rating">';
						
            						for($x=1;$x<=$packagerating;$x++)
            						    {
                    						$commondiv .=  '<img src="images/starrate.png" />'; //star
                						}
                						if (strpos($packagerating,'.')) 
                						{
                   					 $commondiv .=  '<img src="images/starrate.png" />';   //half star
                                      $x++;
                                 }
    								while ($x<=5)
    								 {
        							$commondiv .=  '<img src="images/starrateblank.png" />';  //empty star
        								$x++;
    								 }
							
							
                    $commondiv .= '	</fieldset>';       
                    // rating new code add 19-01-2024 end
						
						        // $commondiv .=  '<div typeof="schema:AggregateRating" property="schema:ratingValue" class="rateit-selected rateit-preset" data-rateit-value="'.intval($packagerating).'" data-rateit-ispreset="true" data-rateit-readonly="true"></div>';
						    
                                $commondiv .= '	
						            </div>
						            </div>
						            <div class="booked">'.$availableslots.'</div>
						                <div class="clearfix"></div>
						            <div style="border-top:1px solid #eee; margin-bottom:4px;">
						                <div class="call_action">
							                <div style=" width:50%; margin:auto">
								                <a href ="'.$link.'"><button class="readmore_btn center-block">Read More</button></a>
							                </div>							
						                    <div class="clearfix"></div>
						                </div>
					                </div>
                                </div>
                            </div>
			            </div>
    	            </div>';			
		
					
				//$activefinaldiv = $subsubpackageactiveitemstartdiv.$commondiv.$subsubpackageactiveitemenddiv;
				$activefinaldiv =  $commondiv;		
						//$nonactivefinaldiv = $subsubpackagehideitemstartdiv.$commondiv.$subsubpackagehideitemenddiv;
				
				//		$nonactivefinaldiv = scrolldivpackagelistunactive();
				
				}
				
				$finalresultdiv	=	$activefinaldiv; // .$nonactivefinaldiv;
				return $finalresultdiv;
				
			}
			else
			{
				$pagenameval		=	"Not Found";
				$pagedesc			=	"Sorry, this page are removed or under updation";
			}
	    
	    
	}
	
	function scrolldivpackagelist($packagelist,$noofpackages='4')
	{
		if (is_array($packagelist))
		{
		    $rowcount 			=	count($packagelist);
		}
		$subsubpackageactiveitemstartdiv ='<div class="item active">
												<div class="row bucket-list-tours" >';
												
		$subsubpackageactiveitemenddiv='</div>
											</div>';
		
		$subsubpackagehideitemstartdiv	= '<div class="item">
												<div class="row bucket-list-tours">';
												
		$subsubpackagehideitemenddiv	= '</div>
											   </div>';
		
			if(is_array($packagelist))
			{
				/*if (rowcount > 0 && rowcount < 4)
				{
					$rowcount = 4;
				}*/
				$packagecount = count($packagelist);
				$rowcount = ($packagecount > $noofpackages)?$noofpackages:$packagecount;
				//$rowcount = 4;
				//echo "rowcount ".$rowcount ;
				for($i=0;$i<$rowcount;$i++)
				{
					$packagerating = 0;
					$tourpackageid				=		$packagelist[$i]['tourpackageid'];
					$tourpackagetitle			=		preview_text($packagelist[$i]['tourpackagetitle'],24);
					$tourpackagetitleURL		=		cleanURL(preview_text($packagelist[$i]['tourpackagetitle'],50));
					
					$readmorephotothumb			=		$packagelist[$i]['readmorephotothumb'];
					$homepagephotothumb			=		$packagelist[$i]['homepagephotothumb'];
					$packagevalidfromdate		=		($packagelist[$i]['packagevalidfromdate']!='0000-00-00')?date('d M Y',strtotime($packagelist[$i]['packagevalidfromdate'])):'';
					$packagevalidtodate			=		($packagelist[$i]['packagevalidtodate']!='0000-00-00')?date('d M Y',strtotime($packagelist[$i]['packagevalidtodate'])):'';
					$noofnights					=		$packagelist[$i]['noofnights'];
					$noofdays					=		$packagelist[$i]['noofdays'];
					$tourstrikethroughcostfrom	=		format_number($packagelist[$i]['tourstrikethroughcostfrom']);
					$tourcostfrom				=		format_number($packagelist[$i]['tourcostfrom']);
					$addionaltourcost 		=		format_number($packagelist[$i]['addionaltourcost']);
					$addionaltourcost 		=		str_replace(".00","",$addionaltourcost);
					$addionaltourcost 		=		str_replace("0","",$addionaltourcost);
					$tourcostcurrency = $packagelist[$i]['tourcostcurrency'];
					$addionaltourcostcurrency = " + ".$packagelist[$i]['addionaltourcostcurrency'];
					$servicetaxpercentage 	=		format_number($pagelist[$i]['servicetaxpercentage']);
					$servicetaxamount			=		format_number($pagelist[$i]['servicetaxamount']);		
					$tourpackageshortdesc		=		strip_tags($packagelist[$i]['tourpackageshortdesc'],200);
					$link						=		DOC_ROOT.'package-'.$tourpackageid.'-'.$tourpackagetitleURL.'-.htm';
					$isspecialpackage			=		$packagelist[$i]['isspecialpackage'];
					$availableslots				= 		$packagelist[$i]['availableslots'];
					$packagerating 				= 		$packagelist[$i]['packagerating'];
					
					$packagevalidfromdatecalc	=		$packagelist[$i]['packagevalidfromdate'];
					$tourcostfromcalc			=		$packagelist[$i]['tourcostfrom'];
										
					$tourstrikethroughcostfrom = str_replace(".00","",$tourstrikethroughcostfrom);
					
					if($tourstrikethroughcostfrom > 0) 
					{
						$strikecondition='<strike>INR  '.$tourstrikethroughcostfrom.'</strike>';
					}else{
						$strikecondition = "";
					}
					
					$tourcostfrom = str_replace(".00","",$tourcostfrom);
					
					if($addionaltourcost <= 0)
					{
						$addionaltourcost = "";
						$addionaltourcostcurrency = "";
					}
					
					if($homepagephotothumb>'')
					{
						 //$pageimagepath1				=	LOGO_THUMB_IMAGE.$pageimagepath;
						   $packageimagepath1				=	PACKAGE_IMAGE.$homepagephotothumb;
					}
					else
					{
						   $packageimagepath1				=	IMAGE_DIR.'noplayerimg.jpeg';
					}
					
					if($isspecialpackage == 1)
					{
							$specialofferdiv 	=	'<div class="badge_save">Special Offer</div>';
					}
					else
					{
							$specialofferdiv	=	'';
					}
					
					if($availableslots=="" || $availableslots=="0" )
					{
						$availableslots = 'Limited Seats';
					} 
					else 
					{
						$availableslots = $availableslots.' Booked';
					} 
					
				
					
					
					
					$sqlText = 'SELECT * FROM GTR_tourpackagediscount where tourpackageid='.$tourpackageid;
					//echo $sqlText;
					// temporary blocked by rajiv on 6th feb 2020 to check loading of home
					// after blocking this query page is working fine.
					// need to check the below query and remove it from the loop
					//$productlisting = $testclass->getInfo('', $sqlText);//mysqli_query($sqlText) or die(mysqli_error());
					//print_r($productlisting);
					$DiscountedPackageCost = "";
					if(is_array($productlisting))
					{
						//print_r($productlisting);
						$productrowcount = count($productlisting);
						for($j=0;$j<$productrowcount;$i++)
						{
							$tourpackagediscountid	   = $productlisting[$j]['tourpackagediscountid'];
							$tourpackageid		         = $productlisting[$j]['tourpackageid'];

							$packagetitle					= $productlisting[$j]['tourpackagetitle'];
							$tourpackagetitleURL			=		cleanURL(preview_text($productlisting[$i]['tourpackagetitle'],50));
							$slot1day1						= $productlisting[$j]['slot1day1'];
							$slot1day2						= $productlisting[$j]['slot1day2'];
							$slot2day1						= $productlisting[$j]['slot2day1'];
							$slot2day2						= $productlisting[$j]['slot2day2'];
							$slot3day1						= $productlisting[$j]['slot3day1'];
							$slot3day2						= $productlisting[$j]['slot3day2'];
							$slot1percentage				= $productlisting[$j]['slot1percentage'];
							$slot2percentage				= $productlisting[$j]['slot2percentage'];
							$slot3percentage				= $productlisting[$j]['slot3percentage'];
							
						
						
						}					
					
$date0  = date('Y-m-d');
$date1 = new DateTime($date0);
$date2 = new DateTime($packagevalidfromdatecalc);
$interval = $date1->diff($date2);
//echo "difference " . $interval->y . " years, " . $interval->m." months, ".$interval->d." days "; 

// shows the total amount of days (not divided into years, months and days like above)
//echo "difference " . $interval->days . " days ";

//echo "<br>Date one ".date_format($date1, 'Y-m-d');
//echo "<br>Date two ".date_format($date2, 'Y-m-d');

$datedif =  $interval->days;
//echo $datedif;
//echo "<br>difference " . $datedif . " days ";
$percent=0;
if($datedif > $slot1day1 && $datedif < $slot1day2 ) 
{
  //echo '<br>30-40';
  $percent=$slot1percentage;
}
elseif($datedif > $slot2day1 && $datedif < $slot2day2) 
{
	//echo '<br>46-60';
	$percent=$slot2percentage;
}
elseif($datedif > $slot3day1 && $datedif < $slot3day2) 
{
	//echo '<br>61-90';
	$percent=slot3percentage;
}

$PackageCost = $tourcostfromcalc;
//echo "<br>Package Cost ".$PackageCost;
//echo "<br>percent ".$percent;

$r1 = $percent;

$b1 = (+$PackageCost)*(+$percent);
$b2 = (+$b1)/100;
$DiscountedPackageCost = (+$PackageCost)-(+$b2);

//echo "<br>Discounted Package Cost ".$DiscountedPackageCost;


}
//echo "<br>Discounted Package Cost ".$DiscountedPackageCost;

if ($DiscountedPackageCost == "" )
{
	$DiscountedPackageCost = $tourcostfromcalc;
}
$DiscountedPackageCost = sanitize(format_number($DiscountedPackageCost),SQL);
$DiscountedPackageCost = str_replace(".00","",$DiscountedPackageCost);	

$price = '';
if($DiscountedPackageCost > 0) 
{
	$price=''.$tourcostcurrency.' '.$DiscountedPackageCost.''.$addionaltourcostcurrency.' '.$addionaltourcost.'';
}			
						$commondiv .= '              
						<div class="col-md-3 col-sm-6">						
				<div class="inner" style="">
					
					<div class="tour_title_home">
					'.$specialofferdiv.'
								
							<div class="img_container">
								<a href ="'.$link.'"><img src="'.$packageimagepath1.'" class="" alt=""></a>
							</div>
					
					</div>
					
				<div class="tour_title">
						<a href ="'.$link.'"><h3>'.$tourpackagetitle.'</h3></a>
						<!--<div class="tour_from">'.$packagevalidfromdate.' - '.$packagevalidtodate.'
                        </div> end rating -->
						<!--<div class="discount_price">'.$strikecondition.'</div>-->
                        <div class="day_nights"><img src="'.DOC_ROOT.'images/time.png" style="width: 17px;margin-right: 3px;"> '.$noofdays.'D / '.$noofnights.'N
						</div>
						<div class="after_discount">
                          '.$price.'
                        </div>
                        <div class="row">
                        <div class="col-md-6">
                        <div class="booked">'.$availableslots.'</div>
							<div class="clearfix"></div>
						<div style=" margin-top:4px;">
						<div class="rating-box">
						<fieldset class="rating">'						
						;
						
						for($x=1;$x<=$packagerating;$x++)
						    {
        						$commondiv .=  '<img src="images/starrate.png" />'; //star
    						}
    						if (strpos($packagerating,'.')) 
    						{
       					 $commondiv .=  '<img src="images/starrate.png" />';   //half star
                          $x++;
                     }
    								while ($x<=5)
    								 {
        							$commondiv .=  '<img src="images/starrateblank.png" />';  //empty star
        								$x++;
    								 }
							
							
$commondiv .= '	
						</fieldset>
						</div>
                        </div>
                        </div>
                        <div class="col-md-6">
                        <div class="call_action">
							<div style="  margin:auto">
								<a href ="'.$link.'"><button class="readmore_btn center-block">Read More</button></a>
							</div>							
					
						</div>
                        </div>
                        
                        </div>
						
						
						
				
            </div>
			</div>
    	</div>';			
		
					
				$activefinaldiv = $subsubpackageactiveitemstartdiv.$commondiv.$subsubpackageactiveitemenddiv;
						
						//$nonactivefinaldiv = $subsubpackagehideitemstartdiv.$commondiv.$subsubpackagehideitemenddiv;
				
				//		$nonactivefinaldiv = scrolldivpackagelistunactive();
				
				}
				
				$finalresultdiv	=	$activefinaldiv.$nonactivefinaldiv;
				return $finalresultdiv;
				
			}
			else
			{
				$pagenameval		=	"Not Found";
				$pagedesc			=	"Sorry, this page are removed or under updation";
			}								
  
		
	}
	
	function scrolldivpackagelistunactive()
	{
		$currentdate  = date('Y-m-d');
		$testclass			=	new AllTables();
		
		$sql				=	"select * from GTR_tourpackages where packagedeleted='0' and packagestatus = 1 and packagevalidfromdate >= '$currentdate' order by packagevalidfromdate limit 0,8"; //,GTR_tourpackages.packagedispfromdate,tourpackagelocation,tourpackagetitle
		//echo $sql;
		$packagelist			=	$testclass->getInfo('',$sql);
		$rowcount 			=	count($packagelist);
		
	
		$subsubpackagehideitemstartdiv	= '<div class="item">
												<div class="row">';
												
		$subsubpackagehideitemenddiv	= '</div>
											   </div>';
		
			if(is_array($packagelist))
			{
				/*if (rowcount > 0 && rowcount < 4)
				{
					$rowcount = 4;
				}*/
				$rowcount = count($packagelist);
				//$rowcount = 4;
				//echo "rowcount ".$rowcount ;
				for($i=0;$i<$rowcount;$i++)
				{
					$packagerating = 0;
					$tourpackageid				=		$packagelist[$i]['tourpackageid'];
					$tourpackagetitle			=		preview_text($packagelist[$i]['tourpackagetitle'],27);
					$tourpackagetitleURL		= 		cleanURL(preview_text($packagelist[$i]['tourpackagetitle'],50));
					$readmorephotothumb			=		$packagelist[$i]['readmorephotothumb'];
					$homepagephotothumb			=		$packagelist[$i]['homepagephotothumb'];
					$packagevalidfromdate		=		date('d M Y',strtotime($packagelist[$i]['packagevalidfromdate']));
					$packagevalidtodate			=		date('d M Y',strtotime($packagelist[$i]['packagevalidtodate']));
					$noofnights					=		$packagelist[$i]['noofnights'];
					$noofdays					=		$packagelist[$i]['noofdays'];
					$tourstrikethroughcostfrom	=		format_number($packagelist[$i]['tourstrikethroughcostfrom']);
					$tourcostfrom				=		format_number($packagelist[$i]['tourcostfrom']);
					$addionaltourcost 		=		format_number($packagelist[$i]['addionaltourcost']);
					$addionaltourcost 		=		str_replace(".00","",$addionaltourcost);
					$addionaltourcost 		=		str_replace("0","",$addionaltourcost);
					$tourcostcurrency = $packagelist[$i]['tourcostcurrency'];
					$addionaltourcostcurrency = " + ".$packagelist[$i]['addionaltourcostcurrency'];
					$servicetaxpercentage 	=		format_number($pagelist[$i]['servicetaxpercentage']);
					$servicetaxamount			=		format_number($pagelist[$i]['servicetaxamount']);		
					$tourpackageshortdesc		=		strip_tags($packagelist[$i]['tourpackageshortdesc'],200);
					$link						=		DOC_ROOT.'package-'.$tourpackageid.'-'.$tourpackagetitleURL.'-.htm';
					$isspecialpackage			=		$packagelist[$i]['isspecialpackage'];
					$availableslots				= 		$packagelist[$i]['availableslots'];
					$packagerating 				= 		$packagelist[$i]['packagerating'];
					
					$packagevalidfromdatecalc	=		$packagelist[$i]['packagevalidfromdate'];
					$tourcostfromcalc			=		$packagelist[$i]['tourcostfrom'];
										
					$tourstrikethroughcostfrom = str_replace(".00","",$tourstrikethroughcostfrom);
					if($tourstrikethroughcostfrom > 0) 
					{
						$strikecondition='<strike>INR  '.$tourstrikethroughcostfrom.'</strike>';
					}
					
					$tourcostfrom = str_replace(".00","",$tourcostfrom);
					
					if($addionaltourcost <= 0)
					{
						$addionaltourcost = "";
						$addionaltourcostcurrency = "";
					}
					
					if($homepagephotothumb>'')
					{
						 //$pageimagepath1				=	LOGO_THUMB_IMAGE.$pageimagepath;
						   $packageimagepath1				=	PACKAGE_IMAGE.$homepagephotothumb;
					}
					else
					{
						   $packageimagepath1				=	IMAGE_DIR.'noplayerimg.jpeg';
					}
					
					if($isspecialpackage == 1)
					{
							$specialofferdiv 	=	'<div class="badge_save">Special Offer</div>';
					}
					else
					{
							$specialofferdiv	=	'';
					}
					
					if($availableslots=="" || $availableslots=="0" )
					{
						$availableslots = 'Limited Seats';
					} 
					else 
					{
						$availableslots = $availableslots.' Booked';
					} 
					
					/*$packagerating1 = "";			
					$packagerating2 = "";			
					$packagerating3 = "";			
					$packagerating4 = "";			
					$packagerating5 = "";			
					
					if($packagerating==1){$packagerating1 = 'checked="checked"';}
					if($packagerating==2){$packagerating2 = 'checked="checked"';}
					if($packagerating==3){$packagerating3 = 'checked="checked"';}
					if($packagerating==4){$packagerating4 = 'checked="checked"';}
					if($packagerating==5){$packagerating5 = 'checked="checked"';}*/
					
					//echo "packagerating ".$packagerating;
					/*echo $packagerating1;
					echo $packagerating2;
					echo $packagerating3;
					echo $packagerating4;
					echo $packagerating5;*/
					
					
					
					$sqlText = 'SELECT * FROM GTR_tourpackagediscount where tourpackageid='.$tourpackageid;
					//echo $sqlText;
					
					$productlisting = $testclass->getInfo('', $sqlText);//mysql_query($sqlText) or die(mysql_error());
					//print_r($productlisting);
					$DiscountedPackageCost = "";
					if(is_array($productlisting))
					{
						//print_r($productlisting);
						$productrowcount = count($productlisting);
						for($j=0;$j<$productrowcount;$i++)
						{
							$tourpackagediscountid	   = $productlisting[$j]['tourpackagediscountid'];
							$tourpackageid		         = $productlisting[$j]['tourpackageid'];

							$packagetitle					= $productlisting[$j]['tourpackagetitle'];
							$slot1day1						= $productlisting[$j]['slot1day1'];
							$slot1day2						= $productlisting[$j]['slot1day2'];
							$slot2day1						= $productlisting[$j]['slot2day1'];
							$slot2day2						= $productlisting[$j]['slot2day2'];
							$slot3day1						= $productlisting[$j]['slot3day1'];
							$slot3day2						= $productlisting[$j]['slot3day2'];
							$slot1percentage				= $productlisting[$j]['slot1percentage'];
							$slot2percentage				= $productlisting[$j]['slot2percentage'];
							$slot3percentage				= $productlisting[$j]['slot3percentage'];
						}					
					
							$date0  = date('Y-m-d');
							$date1 = new DateTime($date0);
							$date2 = new DateTime($packagevalidfromdatecalc);
							$interval = $date1->diff($date2);
							//echo "difference " . $interval->y . " years, " . $interval->m." months, ".$interval->d." days "; 

							// shows the total amount of days (not divided into years, months and days like above)
							//echo "difference " . $interval->days . " days ";

							//echo "<br>Date one ".date_format($date1, 'Y-m-d');
							//echo "<br>Date two ".date_format($date2, 'Y-m-d');

							$datedif =  $interval->days;
							//echo $datedif;
							//echo "<br>difference " . $datedif . " days ";
							$percent=0;
							if($datedif > $slot1day1 && $datedif < $slot1day2 ) 
								{
  									//echo '<br>30-40';
  									$percent=$slot1percentage;
								}
							elseif($datedif > $slot2day1 && $datedif < $slot2day2) 
								{
									//echo '<br>46-60';
									$percent=$slot2percentage;
								}
							elseif($datedif > $slot3day1 && $datedif < $slot3day2) 
								{
									//echo '<br>61-90';
									$percent=slot3percentage;
								}

								$PackageCost = $tourcostfromcalc;
								//echo "<br>Package Cost ".$PackageCost;
								//echo "<br>percent ".$percent;

								$r1 = $percent;
								$b1 = (+$PackageCost)*(+$percent);
								$b2 = (+$b1)/100;
								$DiscountedPackageCost = (+$PackageCost)-(+$b2);

								//echo "<br>Discounted Package Cost ".$DiscountedPackageCost;


				}
//echo "<br>Discounted Package Cost ".$DiscountedPackageCost;

if ($DiscountedPackageCost == "" )
{
	$DiscountedPackageCost = $tourcostfromcalc;
}
$DiscountedPackageCost = sanitize(format_number($DiscountedPackageCost),SQL);
$DiscountedPackageCost = str_replace(".00","",$DiscountedPackageCost);	

$price = '';
if($DiscountedPackageCost > 0) 
{
	$price = ''.$tourcostcurrency.' '.$DiscountedPackageCost.''.$addionaltourcostcurrency.' '.$addionaltourcost.'';
}			
						$commondiv .= '              
						<div class="col-md-3 col-sm-6">						
				<div style="background:#fff ; padding:5px;height:430px;">
					
					<div class="tour_title_home">
					'.$specialofferdiv.'
								
							<div class="img_container">
								<a href="single_tour.html">
								<a href ="'.$link.'"><img src="'.$packageimagepath1.'" class="" alt=""></a>
								
								</a>
							</div>
					
					</div>
					
				<div class="tour_title">
						<a href ="'.$link.'"><h3>'.$tourpackagetitle.'</h3></a>
						<div class="tour_from">'.$packagevalidfromdate.' - '.$packagevalidtodate.'
                        </div><!-- end rating -->
						<div class="discount_price">'.$strikecondition.'</div>
                        <div class="day_nights">'.$noofdays.'D / '.$noofnights.'N
						</div>
						<div class="after_discount">
                          '.$price.'
                        </div>
						
							<div class="clearfix"></div>
						<div style="border-top:1px solid #eee; margin-top:4px;">
						<div class="rating-box">
						<fieldset class="rating">';
						
						for($x=1;$x<=$packagerating;$x++)
						   {
        						$commondiv .=  '<img src="images/starrate.png" />'; //star
    						}
    						if (strpos($packagerating,'.')) 
    						{
       						$commondiv .=  '<img src="images/starrate.png" />';   //half star
                        $x++;
                     }
    						while ($x<=5)
    						{
        						$commondiv .=  '<img src="images/starrateblank.png" />';  //empty star
        						$x++;
    						}
							
							
$commondiv .= '	
						</fieldset>
						</div>
						<div class="booked">'.$availableslots.'</div>
						<div class="clearfix"></div>
						<div style="border-top:1px solid #eee; margin-bottom:4px;">
						
						<div class="call_action">
							<div style=" width:50%; margin:auto">
								<a href ="'.$link.'"><button class="readmore_btn center-block">Read More</button></a>
							</div>							
						<div class="clearfix"></div>
						</div>
					</div>
                    </div>
            </div>
			</div>
    	</div>';			
		
					
				$nonactivefinaldiv = $subsubpackagehideitemstartdiv.$commondiv.$subsubpackagehideitemenddiv;
				
				}
				
				$finalresultdiv	=	$nonactivefinaldiv;
				return $finalresultdiv;
				
			}
			else
			{
				$pagenameval		=	"Not Found";
				$pagedesc			=	"Sorry, this page are removed or under updation";
			}								
  
		
	}
	
	
	function testmonials()
	{
		$testclass			=	new AllTables();
		$sql				=	"select * from msttestimonial";
		//echo $sql;
		$testimoniallist	=	$testclass->getInfo('',$sql);
		$testmonialsrowcount 			=	count($testimoniallist);
		$activestartdiv		=	'<div class="item active">';
		$nonactivediv		=	'<div class="item">';
		$closediv		=	'</div>';
				//echo $testmonialsrowcount;
				for($i=0;$i<$testmonialsrowcount;$i++)
				{
					$testimonial				=	preview_text($testimoniallist[$i]['testimonial'],500);
					$testimonialbyclientname	=	$testimoniallist[$i]['testimonialbyclientname'];
					$testimonialclientimagepath	=	$testimoniallist[$i]['testimonialclientimagepath'];
										
					//echo "<br>testimonial ".$testimonial;
					//echo "<br>testimonialbyclientname ".$testimonialbyclientname;
					//echo "<br>testimonialclientimagepath ".$testimonialclientimagepath;
					
					if($testimonialclientimagepath>'')
					{
						 //$pageimagepath1				=	LOGO_THUMB_IMAGE.$pageimagepath;
						   $testimonialimagepath1				=	PACKAGE_IMAGE.$testimonialclientimagepath;
					}
					else
					{
						   $testimonialimagepath1				=	IMAGE_DIR.'noplayerimg.jpeg';
					}		

					$commondiv	=  '<blockquote>
                                        <div class="row">
                                           <a href="tstmonials.php"><div class="col-sm-8 col-sm-offset-2 inner">
										   <p class="text-muted title6">'.$testimonial.'</p>
										   <div class="clearfix"></div>
										   	<div class="testimonial_name text-blue text-montserrat"><strong>'.$testimonialbyclientname.'</strong></div>
										   			<div class="clearfix"></div>
											<img class="img-circle" src="'.$testimonialimagepath1.'" style="width: 100px;height:100px;">
									
										
                                                
                                            </div></a>
                                        </div>
                                    </blockquote>';
									
					if($i == 0)
					{
						$finalactivediv = $activestartdiv.$commondiv.$closediv;
					}
					else
					{
						$finalnonactivediv	= $finalnonactivediv.$nonactivediv.$commondiv.$closediv;
					}	
						//echo "<br>finalnonactivediv ".$finalnonactivediv;
				}
			
				$FinalTestimonialDiv	=	$finalactivediv.$finalnonactivediv;
				return $FinalTestimonialDiv;
		
	}
	
	function departuredatedata($tourpackageid)
	{
		$testclass			=	new AllTables();
		$sqlFields = "a.tourpackageid,departuredate,totalslots,availableslots";
		$sql	=	"select $sqlFields FROM GTR_tourpackages a INNER JOIN GTR_tourpackageschedule b ON a.tourpackageid = b.tourpackageid WHERE a.tourpackageid = '$tourpackageid' order by departuredate desc";
		//echo $sql;
		$departuredatelist	=	$testclass->getInfo('',$sql);
		//print_r($departuredatelist);
		$rowcount 			=	count($departuredatelist);		
		
		for($i=0;$i<$rowcount;$i++)
		{
			$departuredate	.=	date('d M Y',strtotime($departuredatelist[$i]['departuredate'])).'<br>';
		}
		return $departuredate;
	}
	
	function itenarydata($tourpackageid)
	{
		$testclass			=	new AllTables();
		$sqlFields = "a.tourpackageid,itineraryday,noofnights,itinerarytitle,itinerarydesc,itineraryphotopath";
		$sql = "select $sqlFields from  GTR_tourpackages a inner join GTR_tourpackageItinerary b on a.tourpackageid = b.tourpackageid where a.tourpackageid = '$tourpackageid' order by itineraryday asc";
		//echo $sql;
		$itenarydatalist	=	$testclass->getInfo('',$sql);
		$rowcount 			=	count($itenarydatalist);
		//print_r($itenarydatalist);
		for($i=0;$i<$rowcount;$i++)
		{
				
				$itineraryphotopath	= 	$itenarydatalist[$i]['itineraryphotopath'];
				$noofnights			=	$itenarydatalist[$i]['noofnights'];
				$itinerarytitle		=	$itenarydatalist[$i]['itinerarytitle'];
				$itinerarydesc		=	$itenarydatalist[$i]['itinerarydesc'];
				
				if($itineraryphotopath > '')
				{
					//$pageimagepath1				=	LOGO_THUMB_IMAGE.$pageimagepath;
					$packageimagepath1				=	PACKAGE_IMAGE.$itineraryphotopath;
				}
				else
				{
					$packageimagepath1					=	IMAGE_DIR.'noplayerimg.jpeg';
				}
				
			$commondiv	.=	'<div class="col-md-12 p0 days_inclusions">
									<div class="col-md-4 pl0">
										<img src="'.$packageimagepath1.'" class="img-responsive"/>
									</div>
									<div class="col-md-8">
										<div class="itnry_head_wrap">
											<div class="day-box">Day '.$itenarydatalist[$i]['itineraryday'].'</div>
											<p>'.$itinerarytitle.' ('.$noofnights.' Nights)</p>										
										</div>
										<div class="clearfix"></div>
										<div class="itnary_days">
												'.$itinerarydesc.'
											<h5>Meals</h5>
											
											<div class="col-md-3 itenary_compliment">
											<i class="fa fa-coffee"></i> Breakfast
											</div>
											
											<div class="col-md-3 itenary_compliment">
											<i class="fa fa-cutlery"></i> Lunch
											</div>
											
											<div class="col-md-3 itenary_compliment">
											<i class="fa fa-cutlery"></i> Dinner
											</div>
										</div>
									</div>
								</div>';
		}
		return $commondiv;
		
	}
	
	function format_number($strAmount)
{   
if ($strAmount !='')
    {      
    list($OrgAmount,$DotAmount)= explode ('[.]', $strAmount);    
//    list($OrgAmount)= split ('[.]', $strAmount);    
    
    // -- If Decimal Amount is Blank Then Make It '00 ---- ////
    
    if ($DotAmount =='')
    {
        $DotAmount ='00';
    }
    else if (strlen($DotAmount)==1)
    {
        $DotAmount .= "0"; 
    }        
    // -- End Decimal Amount
    
    $strlength     = strlen($OrgAmount);            // Length Of Amount 
        
    if ($strlength >'0')
    {
        if ($strlength == '1')
        {
            $a = substr($OrgAmount,"0","1");
            $strAm ="$a.$DotAmount";                    
            return($strAm);                     
        }
        else if ($strlength =='2')
        {
            $a = substr($OrgAmount,"0","2");
            $strAm ="$a.$DotAmount";                    
            return($strAm);                     
        }
        else if ($strlength =='3')
        {
            $a = substr($OrgAmount,"0","3");
            $strAm ="$a.$DotAmount";                    
            return($strAm);                 
        }
        else if ($strlength =='4')
        {
            $b = substr($OrgAmount,"1","3");
            $a = substr($OrgAmount,"0","1");
            $strAm ="$a,$b.$DotAmount";                    
            return($strAm);         
        }
        else if ($strlength =='5')
        {
            $b = substr($OrgAmount,"2","3");
            $a = substr($OrgAmount,"0","2");
            $strAm ="$a,$b.$DotAmount";                    
            return($strAm);                 
        }
        else if ($strlength =='6')
        {
            $c = substr($OrgAmount,"3","3");
            $b = substr($OrgAmount,"1","2");
            $a = substr($OrgAmount,"0","1");
            $strAm ="$a,$b,$c.$DotAmount";                    
            return($strAm);         
        }
        else if ($strlength =='7')
        {
            $c = substr($OrgAmount,"4","3");
            $b = substr($OrgAmount,"2","2");
            $a = substr($OrgAmount,"0","2");
            $strAm ="$a,$b,$c.$DotAmount";                    
            return($strAm); 
                            
        }
        else if ($strlength =='8')
        {
            $d = substr($OrgAmount,"5","3");
            $c = substr($OrgAmount,"3","2");
            $b = substr($OrgAmount,"1","2");
            $a = substr($OrgAmount,"0","1");
            $strAm ="$a,$b,$c,$d.$DotAmount";                    
            return($strAm);         
        }
        else if ($strlength =='9')
        {
            $d = substr($OrgAmount,"6","3");
            $c = substr($OrgAmount,"4","2");
            $b = substr($OrgAmount,"2","2");
            $a = substr($OrgAmount,"0","2");
            $strAm ="$a,$b,$c,$d.$DotAmount";                    
            return($strAm); 
        }
        else if ($strlength =='10')
        {    
            $e = substr($OrgAmount,"7","3");
            $d = substr($OrgAmount,"5","2");
            $c = substr($OrgAmount,"3","2");
            $b = substr($OrgAmount,"1","2");
            $a = substr($OrgAmount,"0","1");
            
            $strAm ="$a,$b,$c,$d,$e.$DotAmount";                    
            return($strAm); 
        }
        else if ($strlength =='11')
        {
            $e = substr($OrgAmount,"8","3");
            $d = substr($OrgAmount,"6","2");
            $c = substr($OrgAmount,"4","2");
            $b = substr($OrgAmount,"2","2");
            $a = substr($OrgAmount,"0","2");
            $strAm ="$a,$b,$c,$d,$e.$DotAmount";                    
            return($strAm); 
        }        
    }

	}
}

function PackageNameDropdownList()
	{		
			$subMenu='';
			$menu			=	new AllTables();
			$currentdate  = date('Y-m-d');
			$menulist		=	$menu->getInfo('',"select * from GTR_tourpackages where packagedeleted='0' and GTR_tourpackages.packagevalidfromdate >= '$currentdate' order by GTR_tourpackages.packagevalidfromdate");
			if(is_array($menulist))
			{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$tourpackageid				=		$menulist[$i]['tourpackageid'];
							$tourpackagetitle			=		$menulist[$i]['tourpackagetitle'];
							//$categoryphoto			= 		$menulist[$i]['categoryphotothumb'];
							//$categorydesc 			= 		Preview_text(strip_tags($menulist[$i]['categorydesc']),50);
							//$categorylink			=		$menulist[$i]['categorylink'];	
							//$link					=		DOC_ROOT.'cats-'.$categorylink.'-'.$categoryid.'.html';
							$subMenu				.=		'<option value="'.$tourpackageid.'" >'.$tourpackagetitle.'</option>';
					}
					
					
					return $subMenu;
					
			}
			
	}

	
	
	
	function PackageCost($tourpackagetitle)
	{		
			$subMenu='';
			$menu			=	new AllTables();
			$currentdate  = date('Y-m-d');
			if($tourpackagetitle > '')
			{
				$menulist		=	$menu->getInfo('',"select * from GTR_tourpackages where tourpackagetitle='$tourpackagetitle' and GTR_tourpackages.packagevalidfromdate >= '$currentdate' order by GTR_tourpackages.packagevalidfromdate limit 0,4");
				if(is_array($menulist))
				{
					$rowcount			=		count($menulist);
					for($i=0;$i<$rowcount;$i++)
					{
							$tourpackageid				=		$menulist[$i]['tourpackageid'];
							$tourcostfrom			=		$menulist[$i]['tourcostfrom'];
							//$categoryphoto			= 		$menulist[$i]['categoryphotothumb'];
							//$categorydesc 			= 		Preview_text(strip_tags($menulist[$i]['categorydesc']),50);
							//$categorylink			=		$menulist[$i]['categorylink'];	
							//$link					=		DOC_ROOT.'cats-'.$categorylink.'-'.$categoryid.'.html';
							$subMenu				.=		''.$tourcostfrom.'';
					}
					
					
					return $subMenu;
					
				}
			}
			
	}
	function PackageDiscountCostCalc($PackageCost=0,$percent=0)
	{
		$r1 = $percent;
		$b1 = (+$PackageCost)*(+$percent);
		$b2 = (+$b1)/100;
		$DiscountedPackageCost = (+$PackageCost)-(+$b2);
		return $DiscountedPackageCost;
	}
	setlocale(LC_ALL, 'en_US.UTF8');
	function cleanURL($str, $replace=array(), $delimiter='-') {
		if( !empty($replace) ) {
	  		$str = str_replace((array)$replace, ' ', $str);
	 	}
		
	 	$clean = iconv('UTF-8', 'ASCII//TRANSLIT', $str);
	 	$clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
	 	$clean = strtolower(trim($clean, '-'));
	 	$clean = preg_replace("/[\/|+ -]+/", $delimiter, $clean);
	
	 	return $clean;
	}
	
	function getCarousalOnHomePage($productcount=24)	
	{
		$currentdate  = date('Y-m-d');
		
		$testclass			=	new AllTables();
		//$sql				=	"select *,(select availableslots from GTR_tourpackageschedule where GTR_tourpackageschedule.tourpackageid = GTR_tourpackages.tourpackageid and GTR_tourpackageschedule.departuredate = GTR_tourpackages.packagevalidfromdate limit 0,1)availableslots from GTR_tourpackages order by packagerating desc limit 0,8";
		
		$sql				=	"select * from GTR_tourpackages where packagedeleted='0' and packagestatus = 1 and packagevalidfromdate >= '$currentdate' order by packagevalidfromdate"; //,GTR_tourpackages.packagedispfromdate,tourpackagelocation,tourpackagetitle
		echo $sql;
		$productlisting			=	$testclass->getInfo('',$sql);
		$rowcount 			=	count($productlisting);		
		print_r($productlisting);
			
		if ($rowcount > 0)
		{
			$maxeventrowcount = $productcount;			
			$productonoffer = '<div class="item active">
                  <ul class="thumbnails">';
			$j=0;			
			for ($i=0;$i<$rowcount ;$i++)
			{				
							
						if ($j==$maxeventrowcount)
						{
							break;						
						}
											
						if ((($j%4)==0)&&($j>0))
						{
							$productonoffer .= '</ul>
													</div>
													<div class="item">
                  							<ul class="thumbnails">';					
						}
				
						
							$tourpackagediscountid	   = $productlisting[$j]['tourpackagediscountid'];
							$tourpackageid		         = $productlisting[$j]['tourpackageid'];

							$packagetitle					= $productlisting[$j]['tourpackagetitle'];
							$tourpackagetitleURL			=		cleanURL(preview_text($productlisting[$i]['tourpackagetitle'],50));
							$slot1day1						= $productlisting[$j]['slot1day1'];
							$slot1day2						= $productlisting[$j]['slot1day2'];
							$slot2day1						= $productlisting[$j]['slot2day1'];
							$slot2day2						= $productlisting[$j]['slot2day2'];
							$slot3day1						= $productlisting[$j]['slot3day1'];
							$slot3day2						= $productlisting[$j]['slot3day2'];
							$slot1percentage				= $productlisting[$j]['slot1percentage'];
							$slot2percentage				= $productlisting[$j]['slot2percentage'];
							$slot3percentage				= $productlisting[$j]['slot3percentage'];
							
						
						
										
					
$date0  = date('Y-m-d');
$date1 = new DateTime($date0);
$date2 = new DateTime($packagevalidfromdatecalc);
$interval = $date1->diff($date2);
//echo "difference " . $interval->y . " years, " . $interval->m." months, ".$interval->d." days "; 

// shows the total amount of days (not divided into years, months and days like above)
//echo "difference " . $interval->days . " days ";

//echo "<br>Date one ".date_format($date1, 'Y-m-d');
//echo "<br>Date two ".date_format($date2, 'Y-m-d');

$datedif =  $interval->days;
//echo $datedif;
//echo "<br>difference " . $datedif . " days ";
$percent=0;
if($datedif > $slot1day1 && $datedif < $slot1day2 ) 
{
  //echo '<br>30-40';
  $percent=$slot1percentage;
}
elseif($datedif > $slot2day1 && $datedif < $slot2day2) 
{
	//echo '<br>46-60';
	$percent=$slot2percentage;
}
elseif($datedif > $slot3day1 && $datedif < $slot3day2) 
{
	//echo '<br>61-90';
	$percent=slot3percentage;
}

$PackageCost = $tourcostfromcalc;
//echo "<br>Package Cost ".$PackageCost;
//echo "<br>percent ".$percent;

$r1 = $percent;

$b1 = (+$PackageCost)*(+$percent);
$b2 = (+$b1)/100;
$DiscountedPackageCost = (+$PackageCost)-(+$b2);

//echo "<br>Discounted Package Cost ".$DiscountedPackageCost;


}
//echo "<br>Discounted Package Cost ".$DiscountedPackageCost;

if ($DiscountedPackageCost == "" )
{
	$DiscountedPackageCost = $tourcostfromcalc;
}
$DiscountedPackageCost = sanitize(format_number($DiscountedPackageCost),SQL);
$DiscountedPackageCost = str_replace(".00","",$DiscountedPackageCost);	

if($DiscountedPackageCost > 0) 
{
	$price=''.$tourcostcurrency.' '.$DiscountedPackageCost.''.$addionaltourcostcurrency.' '.$addionaltourcost.'';
}			
						$commondiv .= '              
						<div class="col-md-3 col-sm-6">						
				<div style="background:#fff ; padding:5px;height:430px;">
					
					<div class="tour_title_home">
					'.$specialofferdiv.'
								
							<div class="img_container">
								<a href="single_tour.html">
								<a href ="'.$link.'"><img src="'.$packageimagepath1.'" class="" alt=""></a>
								
								</a>
							</div>
					
					</div>
					
				<div class="tour_title">
						<a href ="'.$link.'"><h3>'.$tourpackagetitle.'</h3></a>
						<div class="tour_from">'.$packagevalidfromdate.' - '.$packagevalidtodate.'
                        </div><!-- end rating -->
						<div class="discount_price">'.$strikecondition.'</div>
                        <div class="day_nights">'.$noofdays.'D / '.$noofnights.'N
						</div>
						<div class="after_discount">
                          '.$price.'
                        </div>
						
							<div class="clearfix"></div>
						<div style="border-top:1px solid #eee; margin-top:4px;">
						<div class="rating-box">
						<fieldset class="rating">'						
						;
						
						for($x=1;$x<=$packagerating;$x++)
						    {
        						$commondiv .=  '<img src="images/starrate.png" />'; //star
    						}
    						if (strpos($packagerating,'.')) 
    						{
       					 $commondiv .=  '<img src="images/starrate.png" />';   //half star
                          $x++;
                     }
    								while ($x<=5)
    								 {
        							$commondiv .=  '<img src="images/starrateblank.png" />';  //empty star
        								$x++;
    								 }
							
							
$commondiv .= '	
						</fieldset>
						</div>
						<div class="booked">'.$availableslots.'</div>
						<div class="clearfix"></div>
						<div style="border-top:1px solid #eee; margin-bottom:4px;">
						
						<div class="call_action">
							<div style=" width:50%; margin:auto">
								<a href ="'.$link.'"><button class="readmore_btn center-block">Read More</button></a>
							</div>							
						<div class="clearfix"></div>
						</div>
					</div>
                    </div>
            </div>
			</div>
    	</div>';			
		
					
				$productonoffer .= '	</ul>
											</div>';					
		}
		return $productonoffer;
	}
	
		function checkIfNullDate($dateToCheck)
    	{
    		$returndate='';
    		if ($dateToCheck =='01-01-1970' || $dateToCheck =='0000-00-00' || $dateToCheck =='1970-01-01 00:00:00' || $dateToCheck =='0000-00-00 00:00:00' || $dateToCheck =='30-11--0001' || $dateToCheck =='30 Nov -0001' || $dateToCheck == '01 Jan 1970')  
    		{
    			$returndate =null;
    		}
    		else 
    		{
    			$returndate =   $dateToCheck;
    		}	
    		return $returndate;        
    	}          


function CountryCodeDropDownList($selectedcountryid='')
{		
    $selectedcountryid = 223;
	$menu			=	new AllTables();
	$sql = "select countrycode,countryid,countryname from mstcountry where countrystatus = 1 order by countryname asc ";
	$menulist		=	$menu -> getInfo('',$sql);
	$rowcount			=		count($menulist);      
	
	$countrycodedata = "<option value='' hidden>Select The Country Code</option>";
	for($i=0;$i<$rowcount;$i++)
	{
		$countryid				=		$menulist[$i]['countryid'];              
		$countrycode			=		$menulist[$i]['countrycode']; 
		$countryname            =       $menulist[$i]['countryname'];
		
		if($selectedcountryid == $countryid)
		{
		    $countrycodedata				.=		"<option value='$countryid,$countrycode' selected >$countrycode- $countryname</option>";    
		}
		else
		{
		    $countrycodedata				.=		"<option value='$countryid,$countrycode' >$countrycode- $countryname</option>";
		}
	}
	return $countrycodedata;
}


function DestinationData()
{		
	$menu			=	new AllTables();
	$sql = "SELECT b.countryname, b.countryid
            FROM GTR_tourpackages a
            INNER JOIN mstcountry b on a.countryid = b.countryid
            WHERE b.countryid != 96
            GROUP BY a.countryid ";
    
    $sql2 = "SELECT c.StateId, c.State
            FROM GTR_tourpackages a
            INNER  JOIN mststate c on a.stateid = c.StateId 
            GROUP BY c.stateid "; 
            
	$countrylistdata		=	$menu -> getInfo('',$sql);
	$statelistdata		=	$menu -> getInfo('',$sql2);
	
	$countrylistcount			=		count($countrylistdata);      
	$statelistcount			=		count($statelistdata);
	
	$destinationdata .= "<option value='' hidden >Select Destination </option>";
	
	for($i=0;$i<$statelistcount;$i++)
	{            
		$stateid			=		$statelistdata[$i]['StateId']; 
		$statename            =       $statelistdata[$i]['State']; 
		
		$destinationdata       .=   "<option value='$statename' >$statename</option>";
	}
	
	for($i=0;$i<$countrylistcount;$i++)
	{            
		$countryid			=		$countrylistdata[$i]['countryid']; 
		$countryname            =       $countrylistdata[$i]['countryname'];
		
		$destinationdata       .=   "<option value='$countryname' >$countryname</option>";
	}
	
	return $destinationdata;
}


function getheaderstatemenu($countryid)
{
    $menu			=	new AllTables();
    $sql = "SELECT c.StateId, c.State
            FROM GTR_tourpackages a
            INNER  JOIN mststate c on a.stateid = c.StateId 
            WHERE c.CountryID = $countryid
            GROUP BY c.stateid ";
    $statelist =	$menu -> getInfo('',$sql);    
    $statelistcount = count($statelist);
    
    if($statelistcount > 0)
    {
        for($i=0; $i<$statelistcount; $i++)
        {
            $stateid = $statelist[$i]['StateId'];
            $statename = $statelist[$i]['State'];
            
            $statepackagelists .= "<a href='statetours.php?cid=$countryid&stateid=$stateid'>$statename</a>";
        }
        
        
        $packagesql_query = "SELECT tourpackagelocation, tourpackageid FROM GTR_tourpackages WHERE countryid = 96 ORDER BY tourpackagelocation ASC";
        $packagesql_data =	$menu -> getInfo('',$packagesql_query);
        $packagecount = count($packagesql_data);
        
        for($j=0;$j<$packagecount;$j++)
        {
            $packageloc_name = $packagesql_data[$j]['tourpackagelocation'];
            $packageid = $packagesql_data[$j]['tourpackageid'];
            
            $statepackagelists .= "<a href='itenary.php?tourpackageid=$packageid'>$packageloc_name</a>";
        }
        
                        
        $statepackagelistshow = "<div class='dropdown-content collapse' id='tourscollapse' style='height: 200px; overflow: auto;'>
                                $statepackagelists
                                </div>";
    }
    else
    {
        $statepackagelistshow = '';
    }
    return $statepackagelistshow;
}



function newheadermenu()
{
    $testclass			=	new AllTables();
	$sqldata = "SELECT b.countryname, b.countryid, b.countryimage 
                FROM GTR_tourpackages a
                INNER JOIN mstcountry b on a.countryid = b.countryid
                GROUP BY a.countryid
                ORDER BY
                CASE 
                WHEN b.countryname = 'INDIA' THEN 0 
                ELSE 1 
                END,  
                b.countryname ASC "; 
    $countrylist			=	$testclass->getInfo('',$sqldata);     
    $datacount = count($countrylist);
    
    for($i=0;$i<$datacount;$i++)
    {
        $countryname = $countrylist[$i]['countryname'];
        $countryid = $countrylist[$i]['countryid'];
        $countryimage = $countrylist[$i]['countryimage'];
        
        $statelisting = getheaderstatemenu($countryid);
        
        
        $countrydropdown .= "<div class='col-sm-4 multi-gd-img'>
                        	<ul class='multi-column-dropdown list-unstyled'>
                        	<li class='list dropdown-hover hidden-xs'>
                        	<div class='drop-image dropbtn'>
                        	<a href='country.php?id=".$countryid."'> <img src='".COUNTRY_IMAGE."".$countryimage."' style='width: 100%;   height: 100px;    object-fit: cover;'></a>
                        	</div>
                        	<h4 class='mega_location_name'><a href='country.php?id=".$countryid."'>".$countryname."</a></h4>
                        	$statelisting
                        	</li>
                        	</ul>
                        	</div>";    
    }            
	return $countrydropdown;
}


function getCountryListForIndex($GCountry='')
	{
		
		$testclass		=	new AllTables();
		$sql    = "SELECT  b.countryid  , b.countryname   
		            FROM `GTR_tourpackages` a 
                    INNER JOIN mstcountry   b on a.countryid = b.countryid 
                    GROUP BY b.countryname";
		$countrylist 	=	$testclass->getInfo('', $sql);
		
		$rowcount = count($countrylist);
		
		$strCountryList = "";
		
		if ($rowcount > 0)
		{
			$currentcountry = strtolower(rtrim(ltrim($GCountry))); 
			for($i=0;$i<$rowcount;$i++) 	
			{	
				$databasecountry = strtolower(rtrim(ltrim($countrylist[$i]['countryname'])));
				$compare = strcmp($currentcountry,$databasecountry);
				
				if ($compare == 0)
				{
					$strCountryList .= "<option value='".$countrylist[$i]['countryid']."' selected='selected'>".ucwords(strtolower($countrylist[$i]['countryname']))."</option>";
				}
				else
				{	
					$strCountryList .= "<option value='".$countrylist[$i]['countryid']."'>".ucwords(strtolower($countrylist[$i]['countryname']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strCountryList;	      
	}
    
    function getLocationsForIndex($packageLocation='' , $countryid='')
	{
		
		$testclass		=	new AllTables();
		$sql    = "SELECT  a.tourpackagelocation   FROM `GTR_tourpackages` a 
                    INNER JOIN mstcountry b on a.countryid = b.countryid 
                    GROUP BY a.tourpackagelocation";
        
        if($countryid!='')
        {
            $sql    = "SELECT  a.tourpackagelocation   FROM `GTR_tourpackages` a 
                        INNER JOIN mstcountry b on a.countryid = b.countryid 
                        where a.countryid=$countryid 
                        GROUP BY a.tourpackagelocation";   
        }
                
		$locations 	=	$testclass->getInfo('', $sql);
		
		$rowcount = count($locations);
		
		$strlocations = "";
		
		if ($rowcount > 0)
		{
			$currentcountry = strtolower(rtrim(ltrim($packageLocation))); 
			for($i=0;$i<$rowcount;$i++) 	
			{	
				$databasecountry = strtolower(rtrim(ltrim($locations[$i]['tourpackagelocation'])));    
				$compare = strcmp($currentcountry,$databasecountry);
				
				if ($compare == 0)
				{
					$strlocations .= "<option value='".$locations[$i]['tourpackagelocation']."' selected='selected'>".ucwords(strtolower($locations[$i]['tourpackagelocation']))."</option>";
				}
				else
				{	
					$strlocations .= "<option value='".$locations[$i]['tourpackagelocation']."'>".ucwords(strtolower($locations[$i]['tourpackagelocation']))."</option>";
				}
			}
		}
		unset($testclass);
		return $strlocations;	     
	}

function DestinationImageData()
{
	$menu   = new AllTables();
	$sql    = "SELECT b.countryname, b.countryid, a.homepagephotothumb
            FROM GTR_tourpackages a
            INNER JOIN mstcountry b on a.countryid = b.countryid
            WHERE b.countryid != 96
            GROUP BY a.countryid ";  
    
    $sql2 = "SELECT c.StateId, c.State, a.homepagephotothumb
            FROM GTR_tourpackages a
            INNER  JOIN mststate c on a.stateid = c.StateId 
            GROUP BY c.stateid "; 
            
	$countrylistdata		=	$menu -> getInfo('',$sql);
	$statelistdata		=	$menu -> getInfo('',$sql2);
	
	$countrylistcount			=		count($countrylistdata);      
	$statelistcount			=		count($statelistdata);
	
	for($i=0;$i<$statelistcount;$i++)
	{            
		$stateid			=		$statelistdata[$i]['StateId']; 
		$statename            =       $statelistdata[$i]['State'];
		$imagename          =       $statelistdata[$i]['homepagephotothumb'];
		
		$destinationdata .= "<div class='col-sm-4 multi-gd-img' style='height:150px;' >
                        	<ul class='multi-column-dropdown list-unstyled'>
                        	<li class='list dropdown-hover'> 
                        	<div class='drop-image dropbtn'>
                        	<a href='gallery.php?stid=".$stateid."'> <img src='".DOC_ROOT."userdata/images/".$imagename."' style='width: 100%; height: 100px; object-fit: cover;'></a>
                        	</div>
                        	<h4 class='mega_location_name'><a href='gallery.php?stid=".$stateid."'>".$statename."</a></h4>
                        	</li>
                        	</ul>
                        	</div>";
	}
	
	for($i=0;$i<$countrylistcount;$i++)
	{            
		$countryid			=		$countrylistdata[$i]['countryid']; 
		$countryname            =       $countrylistdata[$i]['countryname'];
		$imagename          =       $countrylistdata[$i]['homepagephotothumb'];
		
		$destinationdata .= "<div class='col-sm-4 multi-gd-img' style='height:150px;' > 
                        	<ul class='multi-column-dropdown list-unstyled'>
                        	<li class='list dropdown-hover'>
                        	<div class='drop-image dropbtn'>
                        	<a href='gallery.php?ctid=".$countryid."'> <img src='".DOC_ROOT."userdata/images/".$imagename."' style='width: 100%; height: 100px; object-fit: cover;'></a>
                        	</div>
                        	<h4 class='mega_location_name'><a href='gallery.php?ctid=".$countryid."'>".$countryname."</a></h4>
                        	</li>
                        	</ul>
                        	</div>";
	}
	
	return $destinationdata;
}

?>