<?php

		class Validation{
				
				private $validusername 	= "/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+.[a-zA-Z0-9-.]+$/i";
				
				private $validpassword 	= "/^[A-Za-z0-9@#$]+$/i";
				
				//private $validpassword 	= "/^(?=.*[A-Z])(?=.*[a-z])(?=.*[!@#$%^&*-])(?=.*[0-9]).{8,20}$/";
				
				private $validemail 		= "/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+.[a-zA-Z0-9-.]+$/i";
				
				
                public function has_error($key=""){
                    if($key != ""){
                        if(isset($_SESSION[$key])){
                            
                            if($_SESSION[$key] == "" || $_SESSION[$key] == null){
                               unset($_SESSION[$key]); 
                            }else{
                                return $_SESSION[$key];
                            }
                        }
                    }
                }
            
				//Check Username
				public function check_username($key, $var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) < 6){
								$error .= "$label should be greater than 6 digits <br>";
						}else if(!preg_match($this->validusername, $var)){
								$error .= "Please enter valid $label <br>";
						}else{
                                $error .= '';
                        }
						$_SESSION[$key] = $error;
						return $error;
				}
				
				
				//Check Password
				public function check_password($key, $var,$label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) < 8){
								$error .= "$label should be greater than 8 digits <br>";
						}else if(!preg_match($this->validpassword, $var)){
								$error .= "Please enter valid $label <br>";
						}else{
                                $error .= '';
                        }
                    
                        $_SESSION[$key] = $error;
						return $error;
				}	
				
				
				//Check confirm  Password
				public function check_confirm_password($key, $var, $label,$passwordvar){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) < 8){
								$error .= "$label should be greater than 8 digits <br>";
						}else if(!preg_match($this->validpassword, $var)){
								$error .= "Please enter valid  $label <br>";
						}
						elseif($var !== $passwordvar) {
								$error .= " $label not match <br>";
                        }
						$_SESSION[$key] = $error;
						return $error;
				}	
				
				//Check empty field
				public function check_blank($key, $var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else{
                                $error .= '';
                        }
						$_SESSION[$key] = $error;
						
						return $error;
				}
				
				
				//Check Email
				public function check_email($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(!preg_match($this->validemail, $var)){
								$error .= "Please enter valid $label <br>";
						}
						
						return $error;
				}	
				
				
				//Check Contact No
				public function check_contact($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) != 10){
								$error .= "Please enter 10 digits $label <br>";
						}else if(!is_numeric($var)){
								$error .= "Please enter Only Number <br>";
						}
						
						return $error;
				}
				
				
				//Check empty dropdown
				public function select_blank($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please select $label <br>";
						}
						
						return $error;
				}	
				
				
				//Check Pincode
				public function check_pincode($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) != 6){
								$error .= "Please enter 6 digits $label <br>";
						}else if(!is_numeric($var)){
								$error .= "Please enter Only Number <br>";
						}
						
						return $error;
				}
		
		}
?>