<?php

		class Validation{
				
				private $validusername 	= "/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+.[a-zA-Z0-9-.]+$/i";
				
				private $validpassword 	= "/^[A-Za-z0-9@#$]+$/i";
				
				//private $validpassword 	= "/^(?=.*[A-Z])(?=.*[a-z])(?=.*[!@#$%^&*-])(?=.*[0-9]).{8,20}$/";
				
				private $validemail 		= "/^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+.[a-zA-Z0-9-.]+$/i";
				
				
				//Check Username
				public function check_username($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) < 6){
								$error .= "$label should be greater than 6 digits <br>";
						}else if(!preg_match($this->validusername, $var)){
								$error .= "Please enter valid $label <br>";
						}
						
						return $error;
				}
				
				
				//Check Password
				public function check_password($var,$label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) < 8){
								$error .= "$label should be greater than 8 digits <br>";
						}else if(!preg_match($this->validpassword, $var)){
								$error .= "Please enter valid $label <br>";
						}
						return $error;
				}	
				
				
				//Check confirm  Password
				public function check_confirm_password($var, $label,$passwordvar){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) < 8){
								$error .= "$label should be greater than 8 digits <br>";
						}else if(!preg_match($this->validpassword, $var)){
								$error .= "Please enter valid  $label <br>";
						}
						elseif($var !== $passwordvar) {
								$error .= " $label not match <br>";
						}
						
						return $error;
				}	
				
				//Check empty field
				public function check_blank($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}
						
						return $error;
				}
				
				
				//Check Email
				public function check_email($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(!preg_match($this->validemail, $var)){
								$error .= "Please enter valid $label <br>";
						}
						
						return $error;
				}	
				
				
				//Check Contact No
				public function check_contact($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) != 10){
								$error .= "Please enter 10 digits $label <br>";
						}else if(!is_numeric($var)){
								$error .= "Please enter Only Number <br>";
						}
						
						return $error;
				}
				
				
				//Check empty dropdown
				public function select_blank($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please select $label <br>";
						}
						
						return $error;
				}	
				
				
				//Check Pincode
				public function check_pincode($var, $label){
						$error = '';
						if($var == ""){
								$error .= "Please enter $label <br>";
						}else if(strlen($var) != 6){
								$error .= "Please enter 6 digits $label <br>";
						}else if(!is_numeric($var)){
								$error .= "Please enter Only Number <br>";
						}
						
						return $error;
				}
		
		}
?>