  // Get Bootstrap theme colors from CSS
  const getVar = (name) => getComputedStyle(document.documentElement).getPropertyValue(name).trim();

  const primary = getVar('--bs-primary');
  const success = getVar('--bs-success');
  const info = getVar('--bs-info');
  const warning = getVar('--bs-warning');
  const danger = getVar('--bs-danger');
  const secondary = getVar('--bs-secondary');
  const labelColor = getVar('--bs-heading-color');

  // Delayed animation settings
  const delayedAnimation = {
    animation: {
      delay: ctx => ctx.dataIndex * 300,
      duration: 1000
    }
  };

  // 🟦 BAR CHART - New Members
  new Chart(document.getElementById('memberBarChart'), {
    type: 'bar',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        label: 'New Members',
        data: [40, 55, 48, 60, 75, 90],
        backgroundColor: primary
      }]
    },
    options: {
      plugins: {
        title: { display: false }
      },
      responsive: true,
      maintainAspectRatio: false,
      scales: {
        x: {
          ticks: { color: labelColor }
        },
        y: {
          ticks: { color: labelColor }
        }
      },
      ...delayedAnimation
    }
  });

  // 🟩 LINE CHART - Revenue
  new Chart(document.getElementById('revenueLineChart'), {
    type: 'line',
    data: {
      labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun'],
      datasets: [{
        label: 'Revenue (₹)',
        data: [40000, 55000, 48000, 60000, 75000, 90000],
        borderColor: success,
        backgroundColor: success + '33',
        fill: true,
        tension: 0.4
      }]
    },
    options: {
      plugins: {
        title: { display: false }
      },
      responsive: true,
      maintainAspectRatio: false,
      scales: {
        x: {
          ticks: { color: labelColor }
        },
        y: {
          ticks: { color: labelColor }
        }
      },
      ...delayedAnimation
    }
  });

  // 🟧 PIE CHART - Membership Type Distribution
  new Chart(document.getElementById('membershipPieChart'), {
    type: 'pie',
    data: {
      labels: ['Regular', 'Premium', 'Student', 'Senior Citizen'],
      datasets: [{
        label: 'Members',
        data: [50, 30, 15, 5],
        backgroundColor: [info, warning, danger, secondary]
      }]
    },
    options: {
      plugins: {
        title: { display: false },
        legend: {
          labels: { color: labelColor }
        }
      },
      responsive: true,
      maintainAspectRatio: false,
      animation: {
        animateRotate: true,
        animateScale: true,
        delay: 500,
        duration: 1500
      }
    }
  });
