$(document).ready(function () {
    // Initialize Bootstrap Wizard
    $("#rootwizard").bootstrapWizard({
        onNext: function (tab, navigation, index) {
            const formSelector = $(tab).data("targetForm");
            // const form = $(formSelector);
            const form = $('#accountForm');
            // Trigger validation 
            form.addClass("was-validated");
            
            if (!form || !form[0] || typeof form[0].checkValidity !== 'function') 
            {
                console.error("Form is not defined or doesn't support checkValidity");
                return false; 
            }

            if (form[0].checkValidity() === false) {    
                // Prevent moving to next tab
                return false;
            }  
        },

        onTabClick: function (tab, navigation, index) {
            const formSelector = $(tab).data("targetForm");
            const form = $(formSelector);

            // Optional: Prevent direct clicking to tab if form is invalid
            if (form.length && form[0].checkValidity() === false) {
                form.addClass("was-validated");
                return false;
            }
        }
    });

    // Optional: prevent default HTML5 form submit
    // $("form").on("submit", function (e) {
    //     e.preventDefault();
    // });
});
