<?php
require_once "../include/config.php";
require_once GLOBAL_INCLUDE_PATH . "include/startup.php";
$alltable = new AllTables();


// Fetch all data
$sql = "SELECT * FROM visitor_reg ORDER BY Formid DESC";
$data = $alltable->getInfo('', $sql);

// Set CSV Headers
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=visitor_report.csv');

// Create output stream
$output = fopen('php://output', 'w');

// Column headings
fputcsv($output, [
    'Sr No',
    'Name',
    'Company',
    'Country',
    'City',
    'Country Code',
    'Mobile',
    'Email',
    'Status',
    'Entry Date'
]);

// Add rows
if (!empty($data)) {
    foreach ($data as $i => $row) {

        $status = ($row['is_verified_user'] == 1) ? "Verified" : "Unverified";
        $countryname = getcountryname($row['country']);

        fputcsv($output, [
            $i + 1,
            $row['name'],
            $row['companyname'],
            $countryname,
            $row['city'],
            $row['country_code'],
            $row['mobileno'],
            $row['Email'],
            $status,
            date("d-m-Y", strtotime($row['entry_date']))
        ]);
    }
}

fclose($output);
exit();
?>
